/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.text;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.text.serializer.TextSerializer;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.common.text.serializer.JsonTextSerializer;
import org.spongepowered.common.text.serializer.PlainTextSerializer;
import org.spongepowered.common.text.serializer.SpongeFormattingCodeTextSerializer;

public final class TextSerializerRegistryModule
implements AlternateCatalogRegistryModule<TextSerializer>,
AdditionalCatalogRegistryModule<TextSerializer> {
    @RegisterCatalog(value=TextSerializers.class)
    private final Map<String, TextSerializer> textSerializerMappings = new HashMap<String, TextSerializer>();

    @Override
    public Optional<TextSerializer> getById(String id) {
        return Optional.ofNullable(this.textSerializerMappings.get(id));
    }

    @Override
    public Collection<TextSerializer> getAll() {
        return ImmutableList.copyOf(this.textSerializerMappings.values());
    }

    @Override
    public void registerDefaults() {
        this.registerSerializer(new PlainTextSerializer());
        this.registerSerializer(new JsonTextSerializer());
        this.registerSerializer(new SpongeFormattingCodeTextSerializer("sponge:formatting_code", "Formatting Codes", '&'));
        this.registerSerializer(new SpongeFormattingCodeTextSerializer("minecraft:legacy_formatting_code", "Legacy Formatting Codes", '\u00a7'));
    }

    private void registerSerializer(TextSerializer serializer) {
        this.textSerializerMappings.put(serializer.getId(), serializer);
    }

    @Override
    public void registerAdditionalCatalog(TextSerializer serializer) {
        this.textSerializerMappings.put(serializer.getId(), serializer);
    }

    @Override
    public Map<String, TextSerializer> provideCatalogMap() {
        HashMap<String, TextSerializer> map = new HashMap<String, TextSerializer>();
        for (Map.Entry<String, TextSerializer> entry : this.textSerializerMappings.entrySet()) {
            map.put(entry.getKey().replace("minecraft:", "").replace("sponge:", ""), entry.getValue());
        }
        return map;
    }
}

