/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import org.spongepowered.api.registry.RegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.registry.RegistryHelper;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class BlockChangeFlagRegistryModule
implements RegistryModule {
    @RegisterCatalog(value=BlockChangeFlags.class)
    private final Map<String, SpongeBlockChangeFlag> flags = new LinkedHashMap<String, SpongeBlockChangeFlag>();
    private final Int2ObjectMap<SpongeBlockChangeFlag> maskedFlags = new Int2ObjectLinkedOpenHashMap(70);
    private static BlockChangeFlagRegistryModule INSTANCE = new BlockChangeFlagRegistryModule();

    public static BlockChangeFlagRegistryModule getInstance() {
        return INSTANCE;
    }

    public static SpongeBlockChangeFlag fromNativeInt(int flag) {
        if (flag == 3) {
            return (SpongeBlockChangeFlag)BlockChangeFlags.ALL;
        }
        if (flag == 2) {
            return (SpongeBlockChangeFlag)BlockChangeFlags.PHYSICS_OBSERVER;
        }
        SpongeBlockChangeFlag spongeBlockChangeFlag = (SpongeBlockChangeFlag)BlockChangeFlagRegistryModule.getInstance().maskedFlags.get(flag);
        if (spongeBlockChangeFlag != null) {
            return spongeBlockChangeFlag;
        }
        return (SpongeBlockChangeFlag)BlockChangeFlags.ALL;
    }

    public static BlockChangeFlag andNotifyClients(BlockChangeFlag flag) {
        int rawFlag = ((SpongeBlockChangeFlag)flag).getRawFlag();
        if ((rawFlag & 2) != 0) {
            return flag;
        }
        return BlockChangeFlagRegistryModule.fromNativeInt(rawFlag & 0xFFFFFFFD);
    }

    private BlockChangeFlagRegistryModule() {
    }

    @Override
    public void registerDefaults() {
        for (int i = 0; i < 64; ++i) {
            StringJoiner builder = new StringJoiner("|");
            if ((i & 1) != 0) {
                builder.add(Flag.NOTIFY_NEIGHBOR.name);
            }
            if ((i & 2) != 0) {
                builder.add(Flag.NOTIFY_CLIENTS.name);
            }
            if ((i & 4) != 0) {
                builder.add(Flag.IGNORE_RENDER.name);
            }
            if ((i & 8) != 0) {
                builder.add(Flag.FORCE_RE_RENDER.name);
            }
            if ((i & 0x10) == 0) {
                builder.add(Flag.IGNORE_OBSERVER.name);
            }
            if ((i & 0x20) == 0) {
                builder.add(Flag.IGNORE_PHYSICS.name);
            }
            if (58 == i) {
                this.register(new SpongeBlockChangeFlag("NONE".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (3 == i) {
                this.register(new SpongeBlockChangeFlag("ALL".toLowerCase(Locale.ENGLISH), i));
                this.register(new SpongeBlockChangeFlag("NEIGHBOR_PHYSICS_OBSERVER".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (51 == i) {
                this.register(new SpongeBlockChangeFlag("NEIGHBOR".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (18 == i) {
                this.register(new SpongeBlockChangeFlag("PHYSICS".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (34 == i) {
                this.register(new SpongeBlockChangeFlag("OBSERVER".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (19 == i) {
                this.register(new SpongeBlockChangeFlag("NEIGHBOR_PHYSICS".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (35 == i) {
                this.register(new SpongeBlockChangeFlag("NEIGHBOR_OBSERVER".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (2 == i) {
                this.register(new SpongeBlockChangeFlag("PHYSICS_OBSERVER".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            this.register(new SpongeBlockChangeFlag(builder.toString().toLowerCase(Locale.ENGLISH), i));
        }
        RegistryHelper.mapFields(BlockChangeFlags.class, this.flags);
    }

    private void register(SpongeBlockChangeFlag flag) {
        this.maskedFlags.put(flag.getRawFlag(), (Object)flag);
        this.flags.put(flag.getName(), flag);
    }

    public Collection<SpongeBlockChangeFlag> getValues() {
        return Collections.unmodifiableCollection(this.flags.values());
    }

    public static final class Flag {
        public static final Flag NOTIFY_NEIGHBOR = new Flag("NEIGHBOR", 1);
        public static final Flag NOTIFY_CLIENTS = new Flag("NOTIFY_CLIENTS", 2);
        public static final Flag IGNORE_RENDER = new Flag("IGNORE_RENDER", 4);
        public static final Flag FORCE_RE_RENDER = new Flag("FORCE_RE_RENDER", 8);
        public static final Flag IGNORE_OBSERVER = new Flag("OBSERVER", 16);
        public static final Flag IGNORE_PHYSICS = new Flag("PHYSICS", 32);
        private static final ImmutableList<Flag> flags = ImmutableList.of((Object)NOTIFY_NEIGHBOR, (Object)NOTIFY_CLIENTS, (Object)IGNORE_RENDER, (Object)FORCE_RE_RENDER, (Object)IGNORE_OBSERVER, (Object)IGNORE_PHYSICS);
        private final String name;
        private final int mask;

        public static Collection<Flag> values() {
            return flags;
        }

        private Flag(String name, int mask) {
            this.name = name;
            this.mask = mask;
        }
    }
}

