/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.Teleporter;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.world.PortalAgent;
import org.spongepowered.api.world.PortalAgentType;
import org.spongepowered.api.world.PortalAgentTypes;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.world.ForgeITeleporterBridge;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.world.SpongePortalAgentType;

public final class PortalAgentRegistryModule
implements SpongeAdditionalCatalogRegistryModule<PortalAgentType>,
AlternateCatalogRegistryModule<PortalAgentType> {
    @RegisterCatalog(value=PortalAgentTypes.class)
    private final Map<String, PortalAgentType> portalAgentTypeMappings = new HashMap<String, PortalAgentType>();
    private final Map<Class<? extends PortalAgent>, PortalAgentType> portalAgentClassToTypeMappings = new HashMap<Class<? extends PortalAgent>, PortalAgentType>();

    public static PortalAgentRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public Optional<PortalAgentType> getById(String id) {
        return Optional.ofNullable(this.portalAgentTypeMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<PortalAgentType> getAll() {
        return ImmutableList.copyOf(this.portalAgentTypeMappings.values());
    }

    @Override
    public void registerAdditionalCatalog(PortalAgentType portalAgentType) {
        Preconditions.checkArgument((this.portalAgentTypeMappings.get(portalAgentType.getId()) == null ? 1 : 0) != 0, (Object)("Cannot re-register a PortalAgent with the same id: " + portalAgentType.getId()));
        this.portalAgentTypeMappings.put(portalAgentType.getId().toLowerCase(Locale.ENGLISH), portalAgentType);
        this.portalAgentClassToTypeMappings.put(portalAgentType.getPortalAgentClass(), portalAgentType);
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerDefaults() {
        Class<Teleporter> clazz = Teleporter.class;
        this.portalAgentTypeMappings.put("minecraft:default", new SpongePortalAgentType("minecraft:default", "Default", clazz));
    }

    @Override
    public Map<String, PortalAgentType> provideCatalogMap() {
        HashMap<String, PortalAgentType> map = new HashMap<String, PortalAgentType>();
        for (Map.Entry<String, PortalAgentType> entry : this.portalAgentTypeMappings.entrySet()) {
            map.put(entry.getKey().replace("minecraft:", ""), entry.getValue());
        }
        return map;
    }

    private PortalAgentRegistryModule() {
    }

    public PortalAgentType validatePortalAgent(String portalAgentTypeClass, String worldName) {
        if (portalAgentTypeClass != null && !portalAgentTypeClass.isEmpty()) {
            try {
                Class<?> clazz = Class.forName(portalAgentTypeClass);
                if (Teleporter.class.isAssignableFrom(clazz)) {
                    return this.validatePortalAgent(clazz);
                }
                SpongeImpl.getLogger().error("Class " + portalAgentTypeClass + " is not a valid PortalAgentType class for world " + worldName + ". Falling back to default type...");
            }
            catch (ClassNotFoundException e) {
                SpongeImpl.getLogger().error("Could not locate PortalAgentType class " + portalAgentTypeClass + " for world " + worldName + ". Falling back to default type...");
            }
        }
        return PortalAgentTypes.DEFAULT;
    }

    public PortalAgentType validatePortalAgent(ForgeITeleporterBridge teleporter) {
        return this.validatePortalAgent(teleporter.getClass());
    }

    private PortalAgentType validatePortalAgent(Class<? extends ForgeITeleporterBridge> clazz) {
        PortalAgentType portalAgentType = this.portalAgentClassToTypeMappings.get(clazz);
        if (portalAgentType != null) {
            return portalAgentType;
        }
        String modId = SpongeImplHooks.getModIdFromClass(clazz);
        if (modId.isEmpty()) {
            return PortalAgentTypes.DEFAULT;
        }
        String teleporterName = clazz.getSimpleName().toLowerCase(Locale.ENGLISH);
        String id = modId.toLowerCase(Locale.ENGLISH) + ":" + teleporterName;
        if (this.portalAgentTypeMappings.get(id) == null) {
            portalAgentType = new SpongePortalAgentType(teleporterName, id, clazz);
            this.portalAgentTypeMappings.put(id, portalAgentType);
            this.portalAgentClassToTypeMappings.put(clazz, portalAgentType);
        }
        return this.portalAgentTypeMappings.get(id);
    }

    private static final class Holder {
        static final PortalAgentRegistryModule INSTANCE = new PortalAgentRegistryModule();

        private Holder() {
        }
    }
}

