/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import io.netty.channel.local.LocalAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.network.play.server.SPacketDisconnect;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketHeldItemChange;
import net.minecraft.network.play.server.SPacketJoinGame;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketServerDifficulty;
import net.minecraft.network.play.server.SPacketSpawnPosition;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.network.RemoteConnection;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.entity.player.EntityPlayerMPBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.entity.player.SpongeUser;
import org.spongepowered.common.mixin.core.server.PlayerListAccessor;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.world.WorldManager;
import org.spongepowered.common.world.storage.SpongePlayerDataHandler;

public final class NetworkUtil {
    public static final String LOCAL_ADDRESS = "local";

    private NetworkUtil() {
    }

    public static String getHostString(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getHostString();
        }
        if (address instanceof LocalAddress) {
            return LOCAL_ADDRESS;
        }
        return address.toString();
    }

    public static String cleanVirtualHost(String host) {
        if ((host = NetworkUtil.substringBefore(host, '\u0000')).endsWith(".")) {
            host = host.substring(0, host.length() - 1);
        }
        return host;
    }

    public static String substringBefore(String s, char c) {
        int pos = s.indexOf(c);
        return pos >= 0 ? s.substring(0, pos) : s;
    }

    public static void initializeConnectionToPlayer(PlayerList playerList, NetworkManager netManager, EntityPlayerMP playerIn, @Nullable NetHandlerPlayServer handler) {
        ClientConnectionEvent.Login loginEvent;
        Player player;
        WorldServer worldServer;
        NBTTagCompound nbttagcompound;
        String s;
        block34: {
            String kickReason;
            GameProfile gameprofile = playerIn.func_146103_bH();
            PlayerProfileCache playerprofilecache = ((PlayerListAccessor)playerList).accessor$getPlayerListServer().func_152358_ax();
            GameProfile gameprofile1 = playerprofilecache.func_152652_a(gameprofile.getId());
            s = gameprofile1 == null ? gameprofile.getName() : gameprofile1.getName();
            playerprofilecache.func_152649_a(gameprofile);
            SpongeUser user = (SpongeUser)((Object)((EntityPlayerMPBridge)playerIn).bridge$getUserObject());
            if (SpongeUser.dirtyUsers.contains(user)) {
                user.save();
            } else {
                user.invalidate();
            }
            nbttagcompound = playerList.func_72380_a(playerIn);
            worldServer = ((PlayerListAccessor)playerList).accessor$getPlayerListServer().func_71218_a(playerIn.field_71093_bK);
            int actualDimensionId = ((WorldServerBridge)worldServer).bridge$getDimensionId();
            Optional<Instant> firstJoined = SpongePlayerDataHandler.getFirstJoined(playerIn.func_110124_au());
            Instant lastJoined = Instant.now();
            SpongePlayerDataHandler.setPlayerInfo(playerIn.func_110124_au(), firstJoined.orElse(lastJoined), lastJoined);
            if (actualDimensionId != playerIn.field_71093_bK) {
                SpongeImpl.getLogger().warn("Player [{}] has attempted to login to unloaded world [{}]. This is not safe so we have moved them to the default world's spawn point.", (Object)playerIn.func_70005_c_(), (Object)playerIn.field_71093_bK);
                BlockPos spawnPos = !firstJoined.isPresent() ? SpongeImplHooks.getRandomizedSpawnPoint(worldServer) : worldServer.func_175694_M();
                playerIn.field_71093_bK = actualDimensionId;
                playerIn.func_70107_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p());
            }
            Text disconnectMessage = (kickReason = playerList.func_148542_a(netManager.func_74430_c(), gameprofile)) != null ? SpongeTexts.fromLegacy(kickReason) : Text.of("You are not allowed to log in to this server.");
            player = (Player)playerIn;
            Transform<World> fromTransform = player.getTransform().setExtent((World)worldServer);
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(user);
                loginEvent = SpongeEventFactory.createClientConnectionEventLogin(frame.getCurrentCause(), fromTransform, fromTransform, (RemoteConnection)netManager, new MessageEvent.MessageFormatter(disconnectMessage), (org.spongepowered.api.profile.GameProfile)gameprofile, player, false);
                if (kickReason != null) {
                    loginEvent.setCancelled(true);
                }
                if (!SpongeImpl.postEvent(loginEvent)) break block34;
                Sponge.getCauseStackManager().popCause();
                Optional message = loginEvent.isMessageCancelled() ? Optional.empty() : Optional.of(loginEvent.getMessage());
                Object reason = message.isPresent() ? SpongeTexts.toComponent((Text)message.get()) : new TextComponentTranslation("disconnect.disconnected", new Object[0]);
                try {
                    ((PlayerListAccessor)playerList).accessor$getPlayerListLogger().info("Disconnecting " + (gameprofile != null ? gameprofile.toString() + " (" + netManager.func_74430_c().toString() + ")" : String.valueOf(netManager.func_74430_c() + ": " + reason.func_150260_c())));
                    netManager.func_179290_a((Packet)new SPacketDisconnect(reason));
                    netManager.func_150718_a(reason);
                }
                catch (Exception exception) {
                    ((PlayerListAccessor)playerList).accessor$getPlayerListLogger().error("Error whilst disconnecting player", (Throwable)exception);
                }
                return;
            }
        }
        worldServer = (WorldServer)loginEvent.getToTransform().getExtent();
        double x = loginEvent.getToTransform().getPosition().getX();
        double y = loginEvent.getToTransform().getPosition().getY();
        double z = loginEvent.getToTransform().getPosition().getZ();
        float pitch = (float)loginEvent.getToTransform().getPitch();
        float yaw = (float)loginEvent.getToTransform().getYaw();
        playerIn.field_71093_bK = ((WorldServerBridge)worldServer).bridge$getDimensionId();
        playerIn.func_70029_a((net.minecraft.world.World)worldServer);
        playerIn.field_71134_c.func_73080_a((WorldServer)playerIn.field_70170_p);
        playerIn.func_70080_a(x, y, z, yaw, pitch);
        worldServer.func_72863_F().func_186028_c(loginEvent.getToTransform().getLocation().getChunkPosition().getX(), loginEvent.getToTransform().getLocation().getChunkPosition().getZ());
        String s1 = LOCAL_ADDRESS;
        if (netManager.func_74430_c() != null) {
            s1 = netManager.func_74430_c().toString();
        }
        WorldInfo worldinfo = worldServer.func_72912_H();
        BlockPos spawnBlockPos = worldServer.func_175694_M();
        ((PlayerListAccessor)playerList).accessor$setPlayerGameType(playerIn, null, (net.minecraft.world.World)worldServer);
        if (handler == null) {
            handler = new NetHandlerPlayServer(((PlayerListAccessor)playerList).accessor$getPlayerListServer(), netManager, playerIn);
        }
        playerIn.field_71135_a = handler;
        SpongeImplHooks.fireServerConnectionEvent(netManager);
        int dimensionId = WorldManager.getClientDimensionId(playerIn, (net.minecraft.world.World)worldServer);
        WorldManager.sendDimensionRegistration(playerIn, worldServer.field_73011_w);
        handler.func_147359_a((Packet)new SPacketJoinGame(playerIn.func_145782_y(), playerIn.field_71134_c.func_73081_b(), worldinfo.func_76093_s(), dimensionId, worldServer.func_175659_aa(), playerList.func_72352_l(), worldinfo.func_76067_t(), worldServer.func_82736_K().func_82766_b("reducedDebugInfo")));
        handler.func_147359_a((Packet)new SPacketCustomPayload("MC|Brand", new PacketBuffer(Unpooled.buffer()).func_180714_a(playerList.func_72365_p().getServerModName())));
        handler.func_147359_a((Packet)new SPacketServerDifficulty(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        handler.func_147359_a((Packet)new SPacketSpawnPosition(spawnBlockPos));
        handler.func_147359_a((Packet)new SPacketPlayerAbilities(playerIn.field_71075_bZ));
        handler.func_147359_a((Packet)new SPacketHeldItemChange(playerIn.field_71071_by.field_70461_c));
        playerList.func_187243_f(playerIn);
        playerIn.func_147099_x().func_150877_d();
        playerIn.func_192037_E().func_192826_c(playerIn);
        ((PlayerListAccessor)playerList).accessor$getPlayerListServer().func_147132_au();
        handler.func_147364_a(x, y, z, yaw, pitch);
        playerList.func_72377_c(playerIn);
        ((PlayerListAccessor)playerList).accessor$getPlayerListLogger().info("{} [{}] logged in with entity id [{}] in {} ({}/{}) at ({}, {}, {}).", (Object)playerIn.func_70005_c_(), (Object)s1, (Object)playerIn.func_145782_y(), (Object)worldServer.func_72912_H().func_76065_j(), (Object)((DimensionType)worldServer.field_73011_w.func_186058_p()).getId(), (Object)((WorldServerBridge)worldServer).bridge$getDimensionId(), (Object)playerIn.field_70165_t, (Object)playerIn.field_70163_u, (Object)playerIn.field_70161_v);
        playerList.func_72354_b(playerIn, worldServer);
        Optional<ResourcePack> pack = ((Server)((PlayerListAccessor)playerList).accessor$getPlayerListServer()).getDefaultResourcePack();
        pack.ifPresent(((Player)playerIn)::sendResourcePack);
        ((EntityPlayerMPBridge)playerIn).bridge$initScoreboard();
        for (PotionEffect potioneffect : playerIn.func_70651_bq()) {
            handler.func_147359_a((Packet)new SPacketEntityEffect(playerIn.func_145782_y(), potioneffect));
        }
        if (nbttagcompound != null) {
            Entity entity1;
            if (nbttagcompound.func_150297_b("RootVehicle", 10)) {
                NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("RootVehicle");
                Entity entity2 = AnvilChunkLoader.func_186051_a((NBTTagCompound)nbttagcompound1.func_74775_l("Entity"), (net.minecraft.world.World)worldServer, (boolean)true);
                if (entity2 != null) {
                    UUID uuid = nbttagcompound1.func_186857_a("Attach");
                    if (entity2.func_110124_au().equals(uuid)) {
                        playerIn.func_184205_a(entity2, true);
                    } else {
                        for (Entity entity : entity2.func_184182_bu()) {
                            if (!entity.func_110124_au().equals(uuid)) continue;
                            playerIn.func_184205_a(entity, true);
                            break;
                        }
                    }
                    if (!playerIn.func_184218_aH()) {
                        ((PlayerListAccessor)playerList).accessor$getPlayerListLogger().warn("Couldn't reattach entity to player");
                        worldServer.func_72973_f(entity2);
                        for (Entity entity3 : entity2.func_184182_bu()) {
                            worldServer.func_72973_f(entity3);
                        }
                    }
                }
            } else if (nbttagcompound.func_150297_b("Riding", 10) && (entity1 = AnvilChunkLoader.func_186051_a((NBTTagCompound)nbttagcompound.func_74775_l("Riding"), (net.minecraft.world.World)worldServer, (boolean)true)) != null) {
                playerIn.func_184205_a(entity1, true);
            }
        }
        playerIn.func_71116_b();
        TextComponentTranslation chatcomponenttranslation = !playerIn.func_70005_c_().equalsIgnoreCase(s) ? new TextComponentTranslation("multiplayer.player.joined.renamed", new Object[]{playerIn.func_145748_c_(), s}) : new TextComponentTranslation("multiplayer.player.joined", new Object[]{playerIn.func_145748_c_()});
        chatcomponenttranslation.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        Text originalMessage = SpongeTexts.toText((ITextComponent)chatcomponenttranslation);
        MessageChannel originalChannel = player.getMessageChannel();
        Sponge.getCauseStackManager().pushCause(player);
        ClientConnectionEvent.Join event = SpongeEventFactory.createClientConnectionEventJoin(Sponge.getCauseStackManager().getCurrentCause(), originalChannel, Optional.of(originalChannel), new MessageEvent.MessageFormatter(originalMessage), player, false);
        SpongeImpl.postEvent(event);
        Sponge.getCauseStackManager().popCause();
        if (!event.isMessageCancelled()) {
            event.getChannel().ifPresent(channel -> channel.send(player, event.getMessage()));
        }
    }
}

