/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenBush;
import org.spongepowered.api.util.weighted.ChanceTable;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedObject;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.populator.Mushroom;
import org.spongepowered.api.world.gen.type.MushroomType;

public class MushroomBuilder
implements Mushroom.Builder {
    private ChanceTable<MushroomType> types;
    @Nullable
    private Function<Location<Extent>, MushroomType> override;
    private VariableAmount count;

    public MushroomBuilder() {
        this.reset();
    }

    @Override
    public Mushroom.Builder types(ChanceTable<MushroomType> types) {
        Preconditions.checkNotNull(types, (Object)"types");
        this.types = types;
        return this;
    }

    @Override
    public Mushroom.Builder type(MushroomType type, double weight) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0);
        this.types.add((TableEntry<MushroomType>)new WeightedObject<MushroomType>(type, weight));
        return this;
    }

    @Override
    public Mushroom.Builder mushroomsPerChunk(VariableAmount count) {
        this.count = (VariableAmount)Preconditions.checkNotNull((Object)count, (Object)"count");
        return this;
    }

    @Override
    public Mushroom.Builder supplier(@Nullable Function<Location<Extent>, MushroomType> override) {
        this.override = override;
        return this;
    }

    @Override
    public Mushroom.Builder from(Mushroom value) {
        ChanceTable<MushroomType> table = new ChanceTable<MushroomType>();
        table.addAll((Collection<TableEntry<MushroomType>>)value.getTypes());
        return this.types(table).mushroomsPerChunk(value.getMushroomsPerChunk()).supplier(value.getSupplierOverride().orElse(null));
    }

    @Override
    public Mushroom.Builder reset() {
        this.types = new ChanceTable();
        this.count = VariableAmount.fixed(1.0);
        this.override = null;
        return this;
    }

    @Override
    public Mushroom build() throws IllegalStateException {
        Mushroom populator = (Mushroom)new WorldGenBush(Blocks.field_150338_P);
        populator.getTypes().addAll((Collection<TableEntry<MushroomType>>)this.types);
        populator.setMushroomsPerChunk(this.count);
        populator.setSupplierOverride(this.override);
        return populator;
    }
}

