/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.Platform;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.plugin.PluginManager;
import org.spongepowered.common.SpongePlatform;
import org.spongepowered.mod.SpongeMod;

@Singleton
public final class SpongeModPlatform
extends SpongePlatform {
    @Inject
    public SpongeModPlatform(PluginManager manager, MinecraftVersion minecraftVersion) {
        super(manager, (PluginContainer)((Object)SpongeMod.instance), minecraftVersion);
        this.platformMap.put("ForgeVersion", ForgeVersion.getVersion());
    }

    @Override
    public Platform.Type getType() {
        switch (FMLCommonHandler.instance().getSide()) {
            case CLIENT: {
                return Platform.Type.CLIENT;
            }
            case SERVER: {
                return Platform.Type.SERVER;
            }
        }
        return Platform.Type.UNKNOWN;
    }

    @Override
    public Platform.Type getExecutionType() {
        return SpongeModPlatform.staticGetExecutionType();
    }

    public static Platform.Type staticGetExecutionType() {
        String threadName = Thread.currentThread().getName();
        if ("Server thread".equals(threadName) || threadName.startsWith("Netty Epoll Server IO #") || threadName.startsWith("Netty Server IO #") || threadName.startsWith("User Authenticator #")) {
            return Platform.Type.SERVER;
        }
        if ("Client thread".equals(threadName) || threadName.startsWith("Netty Client IO #") || threadName.startsWith("Netty Epoll Client IO #") || threadName.startsWith("Netty Local Client IO ") || threadName.startsWith("Netty Local Server IO #")) {
            return Platform.Type.CLIENT;
        }
        if ("Server Infinisleeper".equals(threadName) || "Server console handler".equals(threadName) || "Server Shutdown Thread".equals(threadName)) {
            return Platform.Type.SERVER;
        }
        if (threadName.startsWith("Server Pinger #") || threadName.startsWith("Chunk Batcher ") || "Client Shutdown Thread".equals(threadName) || "Realms-connect-task".equals(threadName) || threadName.startsWith("Texture Downloader #") || threadName.startsWith("Server Connector #") || "Timer hack thread".equals(threadName) || "Twitch authenticator".equals(threadName) || "Twitch shutdown hook".equals(threadName) || "Sound Library Loader".equals(threadName)) {
            return Platform.Type.CLIENT;
        }
        return Platform.Type.UNKNOWN;
    }
}

