/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.command.SpongeCommandFactory;
import org.spongepowered.common.command.args.FilteredPluginsCommandElement;
import org.spongepowered.mod.plugin.SpongeModPluginContainer;

public class SpongeForgeCommandFactory
extends SpongeCommandFactory {
    private static final List<String> MOD_LIST_STATICS = Lists.newArrayList((Object[])new String[]{"minecraft", "mcp", "FML", "forge", "spongeapi", "sponge"});

    public static CommandSpec createSpongeModsCommand() {
        return CommandSpec.builder().description(Text.of("List currently installed mods")).permission("sponge.command.mods").arguments(GenericArguments.optional(new FilteredPluginsCommandElement(Text.of("mod"), SpongeForgeCommandFactory.getFilteredModsPredicate()))).executor((src, args) -> {
            if (args.hasAny("mod")) {
                SpongeForgeCommandFactory.sendContainerMeta(src, args, "mod");
            } else {
                Collection<PluginContainer> containers = SpongeImpl.getGame().getPluginManager().getPlugins();
                ArrayList sortedContainers = new ArrayList();
                MOD_LIST_STATICS.forEach(containerId -> containers.stream().filter(container -> container.getId().equalsIgnoreCase((String)containerId)).findFirst().ifPresent(sortedContainers::add));
                containers.stream().filter(container -> !MOD_LIST_STATICS.contains(container.getId()) && !(container instanceof SpongeModPluginContainer)).sorted(Comparator.comparing(PluginContainer::getName)).forEachOrdered(sortedContainers::add);
                if (src instanceof Player) {
                    ArrayList<Text> containerList = new ArrayList<Text>();
                    PaginationList.Builder builder = PaginationList.builder();
                    builder.title(Text.of(TextColors.RED, "Mods", TextColors.WHITE, " (", sortedContainers.size(), ")")).padding(Text.of(TextColors.DARK_GREEN, "="));
                    for (PluginContainer container2 : sortedContainers) {
                        Text.Builder containerBuilder = Text.builder().append(Text.of(TextColors.RESET, " - ", TextColors.GREEN, container2.getName())).onClick(TextActions.runCommand("/sponge:sponge mods " + container2.getId())).onHover(TextActions.showText(Text.of(TextColors.RESET, "ID: ", container2.getId(), Text.NEW_LINE, "Version: ", container2.getVersion().orElse("Unknown"))));
                        containerList.add(containerBuilder.build());
                    }
                    builder.contents(containerList).build().sendTo(src);
                } else {
                    Text.Builder builder = Text.builder();
                    builder.append(Text.of(TextColors.RED, "Mods", TextColors.WHITE, " (", sortedContainers.size(), "): "));
                    boolean first = true;
                    for (PluginContainer container3 : sortedContainers) {
                        if (!first) {
                            builder.append(SEPARATOR_TEXT);
                        }
                        first = false;
                        builder.append(Text.of(TextColors.GREEN, container3.getName()));
                    }
                    src.sendMessage(builder.build());
                }
            }
            return CommandResult.success();
        }).build();
    }

    private static Predicate<? super PluginContainer> getFilteredModsPredicate() {
        return plugin -> !SpongeCommandFactory.CONTAINER_LIST_STATICS.contains(plugin.getId()) && !(plugin instanceof SpongeModPluginContainer);
    }
}

