/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.forge.fluids;

import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.mod.mixin.core.forge.fluids.BlockFluidBaseMixin_Forge;

@Mixin(value={BlockFluidClassic.class})
public abstract class BlockFluidClassicMixin_Forge
extends BlockFluidBaseMixin_Forge {
    @Nullable
    private Boolean isPreCancelled;

    @Override
    public BiConsumer<CauseStackManager.StackFrame, WorldServerBridge> bridge$getTickFrameModifier() {
        return (frame, world) -> frame.addContext(EventContextKeys.LIQUID_FLOW, (org.spongepowered.api.world.World)((Object)world));
    }

    @Inject(method={"updateTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUpdateTickCheckSpongePre(World world, BlockPos pos, IBlockState state, Random rand, CallbackInfo ci) {
        if (!((WorldBridge)world).bridge$isFake() && ShouldFire.CHANGE_BLOCK_EVENT_PRE && SpongeCommonEventFactory.callChangeBlockEventPre((WorldServerBridge)world, pos).isCancelled()) {
            ci.cancel();
        }
    }

    @Inject(method={"updateTick"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/fluids/BlockFluidClassic;canDisplace(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Z", remap=false)}, cancellable=true)
    private void onCheckDisplaceIfPreAlreadyCancelled(World world, BlockPos pos, IBlockState state, Random rand, CallbackInfo ci) {
        if (this.isPreCancelled == Boolean.TRUE) {
            ci.cancel();
            this.isPreCancelled = null;
        }
    }

    @Redirect(method={"flowIntoBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z"), constraints="FORGE(2821+)")
    private boolean afterCanFlowInto(World targetWorld, BlockPos targetPos, IBlockState newLiquidState, World world, BlockPos pos, int meta) {
        if (((WorldBridge)targetWorld).bridge$isFake() || !ShouldFire.CHANGE_BLOCK_EVENT_BREAK) {
            return world.func_180501_a(targetPos, newLiquidState, 3);
        }
        IBlockState existing = targetWorld.func_180495_p(targetPos);
        if (!existing.func_177230_c().isAir(existing, (IBlockAccess)targetWorld, targetPos) && !existing.func_185904_a().func_76224_d() && existing.func_177230_c() != (BlockFluidClassic)this) {
            ChangeBlockEvent.Break event = SpongeCommonEventFactory.callChangeBlockEventModifyLiquidBreak(world, pos, newLiquidState);
            Transaction<BlockSnapshot> transaction = event.getTransactions().get(0);
            if (event.isCancelled() || !transaction.isValid()) {
                PhaseContext<?> currentContext = PhaseTracker.getInstance().getCurrentContext();
                currentContext.state.processCancelledTransaction(currentContext, transaction, transaction.getOriginal());
                return false;
            }
            if (transaction.getCustom().isPresent()) {
                return targetWorld.func_180501_a(targetPos, (IBlockState)transaction.getFinal().getState(), 3);
            }
        }
        return targetWorld.func_180501_a(targetPos, newLiquidState, 3);
    }
}

