/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.typesafe.config.ConfigException;
import io.github.nucleuspowered.nucleus.NameUtil;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.NucleusAPITokens;
import io.github.nucleuspowered.nucleus.api.service.NucleusMessageTokenService;
import io.github.nucleuspowered.nucleus.api.service.NucleusModuleService;
import io.github.nucleuspowered.nucleus.api.service.NucleusUserPreferenceService;
import io.github.nucleuspowered.nucleus.api.service.NucleusWarmupManagerService;
import io.github.nucleuspowered.nucleus.config.CommandsConfig;
import io.github.nucleuspowered.nucleus.configurate.ConfigurateHelper;
import io.github.nucleuspowered.nucleus.configurate.datatypes.KitConfigDataNode;
import io.github.nucleuspowered.nucleus.configurate.datatypes.UserCacheVersionNode;
import io.github.nucleuspowered.nucleus.dataservices.ItemDataService;
import io.github.nucleuspowered.nucleus.dataservices.KitService;
import io.github.nucleuspowered.nucleus.dataservices.NameBanService;
import io.github.nucleuspowered.nucleus.dataservices.UserCacheService;
import io.github.nucleuspowered.nucleus.dataservices.dataproviders.DataProvider;
import io.github.nucleuspowered.nucleus.dataservices.dataproviders.DataProviders;
import io.github.nucleuspowered.nucleus.dataservices.loaders.UserDataManager;
import io.github.nucleuspowered.nucleus.dataservices.loaders.WorldDataManager;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularGeneralService;
import io.github.nucleuspowered.nucleus.internal.CatalogTypeFinalStaticProcessor;
import io.github.nucleuspowered.nucleus.internal.CommandPermissionHandler;
import io.github.nucleuspowered.nucleus.internal.EconHelper;
import io.github.nucleuspowered.nucleus.internal.InternalServiceManager;
import io.github.nucleuspowered.nucleus.internal.PermissionRegistry;
import io.github.nucleuspowered.nucleus.internal.PreloadTasks;
import io.github.nucleuspowered.nucleus.internal.TextFileController;
import io.github.nucleuspowered.nucleus.internal.client.ClientMessageReciever;
import io.github.nucleuspowered.nucleus.internal.docgen.DocGenCache;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.messages.ConfigMessageProvider;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.internal.messages.ResourceMessageProvider;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionResolverImpl;
import io.github.nucleuspowered.nucleus.internal.permissions.ServiceChangeListener;
import io.github.nucleuspowered.nucleus.internal.qsml.ModuleRegistrationProxyService;
import io.github.nucleuspowered.nucleus.internal.qsml.NucleusConfigAdapter;
import io.github.nucleuspowered.nucleus.internal.qsml.NucleusLoggerProxy;
import io.github.nucleuspowered.nucleus.internal.qsml.QuickStartModuleConstructor;
import io.github.nucleuspowered.nucleus.internal.qsml.event.BaseModuleEvent;
import io.github.nucleuspowered.nucleus.internal.services.CommandRemapperService;
import io.github.nucleuspowered.nucleus.internal.services.PermissionResolver;
import io.github.nucleuspowered.nucleus.internal.services.WarmupManager;
import io.github.nucleuspowered.nucleus.internal.teleport.NucleusTeleportHandler;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTokenServiceImpl;
import io.github.nucleuspowered.nucleus.internal.text.TextParsingUtils;
import io.github.nucleuspowered.nucleus.internal.userprefs.UserPreferenceService;
import io.github.nucleuspowered.nucleus.logging.DebugLogger;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.core.config.WarmupConfig;
import io.github.nucleuspowered.nucleus.modules.core.datamodules.UniqueUserCountTransientModule;
import io.github.nucleuspowered.nucleus.modules.core.services.UUIDChangeService;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.annotations.ModuleData;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.enums.ConstructionPhase;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.IncorrectAdapterTypeException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.NoModuleException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.QuickStartModuleDiscoveryException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.QuickStartModuleLoaderException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.modulecontainers.DiscoveryModuleContainer;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.modulecontainers.discoverystrategies.Strategy;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.slf4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.GameState;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.command.CommandManager;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.game.state.GameStartingServerEvent;
import org.spongepowered.api.event.game.state.GameStoppedServerEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

@Plugin(id="nucleus", name="Nucleus", version="1.9.2-S7.1", description="The Ultimate Essentials Plugin.", dependencies={@Dependency(id="spongeapi", version="7.1.0")})
public class NucleusPlugin
extends Nucleus {
    private static final String divider = "+------------------------------------------------------------+";
    private static final int length = "+------------------------------------------------------------+".length() - 2;
    private final PluginContainer pluginContainer;
    private Instant gameStartedTime = null;
    private boolean hasStarted = false;
    private Throwable isErrored = null;
    private CommandsConfig commandsConfig;
    private ModularGeneralService generalService;
    private ItemDataService itemDataService;
    private UserCacheService userCacheService;
    private UserDataManager userDataManager;
    private WorldDataManager worldDataManager;
    private NameBanService nameBanService;
    private KitService kitService;
    private TextParsingUtils textParsingUtils;
    private NameUtil nameUtil;
    private PermissionResolver permissionResolver = PermissionResolverImpl.INSTANCE;
    private final List<Reloadable> reloadableList = Lists.newArrayList();
    private DocGenCache docGenCache = null;
    private final NucleusTeleportHandler teleportHandler = new NucleusTeleportHandler();
    private NucleusTokenServiceImpl nucleusChatService;
    private final UserPreferenceService userPreferenceService = new UserPreferenceService();
    private final List<Text> startupMessages = Lists.newArrayList();
    private final InternalServiceManager serviceManager = new InternalServiceManager();
    private MessageProvider messageProvider = new ResourceMessageProvider("assets.nucleus.messages");
    private MessageProvider commandMessageProvider = new ResourceMessageProvider("assets.nucleus.commands");
    private WarmupManager warmupManager;
    private final EconHelper econHelper = new EconHelper();
    private final PermissionRegistry permissionRegistry = new PermissionRegistry();
    private DiscoveryModuleContainer moduleContainer;
    private final Map<String, TextFileController> textFileControllers = Maps.newHashMap();
    private final Logger logger;
    private final Path configDir;
    private final Supplier<Path> dataDir;
    @Nullable
    private Path dataFileLocation = null;
    private Path currentDataDir;
    private boolean isServer = false;
    private WarmupConfig warmupConfig;
    @Nullable
    private String versionFail;
    private boolean isDebugMode = false;
    private boolean sessionDebugMode = false;
    private int isTraceUserCreations = 0;
    private boolean savesandloads = false;

    private static boolean versionCheck(MessageProvider provider) throws IllegalStateException {
        Pattern matching = Pattern.compile("^(?<major>\\d+)\\.(?<minor>\\d+)");
        Optional v = Sponge.getPlatform().getContainer(Platform.Component.API).getVersion();
        if (v.isPresent()) {
            Matcher version = matching.matcher("7.1.0");
            if (!version.find()) {
                return false;
            }
            int maj = Integer.parseInt(version.group("major"));
            int min = Integer.parseInt(version.group("minor"));
            boolean notRequiringSnapshot = !"7.1.0".contains("SNAPSHOT");
            Matcher m = matching.matcher((CharSequence)v.get());
            if (m.find()) {
                int major = Integer.parseInt(m.group("major"));
                if (major != maj) {
                    throw new IllegalStateException(provider.getMessageWithFormat("startup.nostart.spongeversion.major", "Nucleus", (String)v.get(), "7.1.0", Sponge.getPlatform().getContainer(Platform.Component.IMPLEMENTATION).getName()));
                }
                int minor = Integer.parseInt(m.group("minor"));
                boolean serverIsSnapshot = ((String)v.get()).contains("SNAPSHOT");
                if (serverIsSnapshot && notRequiringSnapshot) {
                    --minor;
                }
                if (minor < min) {
                    throw new IllegalStateException(provider.getMessageWithFormat("startup.nostart.spongeversion.minor", Sponge.getPlatform().getContainer(Platform.Component.IMPLEMENTATION).getName(), "Nucleus", "7.1.0"));
                }
            }
            return true;
        }
        return false;
    }

    @Inject
    public NucleusPlugin(@ConfigDir(sharedRoot=true) Path configDir, Logger logger, PluginContainer container) {
        Supplier<Path> sp;
        Nucleus.setNucleus(this);
        this.logger = new DebugLogger(logger);
        this.configDir = configDir.resolve("nucleus");
        try {
            Path path = Sponge.getGame().getSavesDirectory();
            sp = () -> path;
            this.isServer = true;
        }
        catch (NullPointerException e) {
            sp = () -> Sponge.getGame().getSavesDirectory();
        }
        this.dataDir = sp;
        this.pluginContainer = container;
    }

    @Listener
    public void onPreInit(GamePreInitializationEvent preInitializationEvent) {
        Object s = Sponge.getGame().isServerAvailable() ? Sponge.getServer().getConsole() : new ClientMessageReciever();
        HoconConfigurationLoader.Builder builder = (HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(Paths.get(this.configDir.toString(), "main.conf"));
        try {
            String location;
            CommentedConfigurationNode node = (CommentedConfigurationNode)builder.build().load();
            String language = node.getNode(new Object[]{"core", "language"}).getString("default");
            if (!language.equalsIgnoreCase("default")) {
                this.messageProvider.setLocale(language);
            }
            if (!(location = node.getNode(new Object[]{"core", "data-file-location"}).getString("default")).equalsIgnoreCase("default")) {
                this.dataFileLocation = Paths.get(location, new String[0]);
            }
        }
        catch (IOException node) {
            // empty catch block
        }
        if (System.getProperty("nucleusnocheck") == null) {
            try {
                if (!NucleusPlugin.versionCheck(this.messageProvider)) {
                    s.sendMessage(this.messageProvider.getTextMessageWithFormat("startup.nostart.nodetect", "Nucleus", "7.1.0"));
                }
            }
            catch (IllegalStateException e) {
                s.sendMessage(this.messageProvider.getTextMessageWithFormat("startup.nostart.compat", "Nucleus", Sponge.getPlatform().getContainer(Platform.Component.IMPLEMENTATION).getName(), Sponge.getPlatform().getContainer(Platform.Component.IMPLEMENTATION).getVersion().orElse("unknown")));
                s.sendMessage(this.messageProvider.getTextMessageWithFormat("startup.nostart.compat2", e.getMessage()));
                s.sendMessage(this.messageProvider.getTextMessageWithFormat("startup.nostart.compat3", "Nucleus"));
                this.versionFail = e.getMessage();
                this.disable();
                return;
            }
        }
        s.sendMessage(this.messageProvider.getTextMessageWithFormat("startup.welcome", "Nucleus", "1.9.2-S7.1", Sponge.getPlatform().getContainer(Platform.Component.API).getVersion().orElse("unknown")));
        this.logger.info(this.messageProvider.getMessageWithFormat("startup.preinit", "Nucleus"));
        Game game = Sponge.getGame();
        NucleusAPITokens.onPreInit(this);
        PreloadTasks.getPreloadTasks().forEach(x -> x.accept(this));
        try {
            Files.createDirectories(this.configDir, new FileAttribute[0]);
            if (this.isServer) {
                Files.createDirectories(this.dataDir.get(), new FileAttribute[0]);
            }
            this.commandsConfig = new CommandsConfig(Paths.get(this.configDir.toString(), "commands.conf"));
            DataProviders d = new DataProviders(this);
            this.generalService = new ModularGeneralService((DataProvider<ConfigurationNode>)d.getGeneralDataProvider());
            this.itemDataService = new ItemDataService(d.getItemDataProvider());
            this.itemDataService.loadInternal();
            this.userDataManager = new UserDataManager(d::getUserFileDataProviders, d::doesUserFileExist);
            this.worldDataManager = new WorldDataManager(d::getWorldFileDataProvider, d::doesWorldFileExist);
            this.kitService = new KitService((DataProvider<KitConfigDataNode>)d.getKitsDataProvider());
            this.nameBanService = new NameBanService((DataProvider<Map<String, String>>)d.getNameBanDataProvider());
            this.userCacheService = new UserCacheService((DataProvider<UserCacheVersionNode>)d.getUserCacheDataProvider());
            this.warmupManager = new WarmupManager();
            this.textParsingUtils = new TextParsingUtils();
            this.registerReloadable(this.textParsingUtils);
            this.nameUtil = new NameUtil();
            if (this.isServer) {
                this.allChange();
            }
        }
        catch (Exception e) {
            this.isErrored = e;
            this.disable();
            e.printStackTrace();
            return;
        }
        PreloadTasks.getPreloadTasks2().forEach(x -> x.accept(this));
        game.getServiceManager().setProvider((Object)this, NucleusModuleService.class, (Object)new ModuleRegistrationProxyService(this));
        game.getServiceManager().setProvider((Object)this, NucleusWarmupManagerService.class, (Object)this.warmupManager);
        this.serviceManager.registerService(WarmupManager.class, this.warmupManager);
        this.serviceManager.registerService(UserPreferenceService.class, this.userPreferenceService);
        Sponge.getServiceManager().setProvider((Object)this, NucleusUserPreferenceService.class, (Object)this.userPreferenceService);
        this.nucleusChatService = new NucleusTokenServiceImpl(this);
        this.serviceManager.registerService(NucleusTokenServiceImpl.class, this.nucleusChatService);
        Sponge.getServiceManager().setProvider((Object)this, NucleusMessageTokenService.class, (Object)this.nucleusChatService);
        this.serviceManager.registerService(CommandRemapperService.class, new CommandRemapperService());
        try {
            String he = this.messageProvider.getMessageWithFormat("config.main-header", "1.9.2-S7.1");
            Optional optionalAsset = Sponge.getAssetManager().getAsset((Object)Nucleus.getNucleus(), "classes.json");
            DiscoveryModuleContainer.Builder db = DiscoveryModuleContainer.builder();
            if (optionalAsset.isPresent()) {
                Map m2 = (Map)new Gson().fromJson(((Asset)optionalAsset.get()).readString(), new TypeToken<Map<String, Map<String, List<String>>>>(){}.getType());
                HashSet sc = Sets.newHashSet();
                for (String classString : m2.keySet()) {
                    sc.add(Class.forName(classString));
                }
                db.setStrategy((string, classloader) -> sc).setConstructor(new QuickStartModuleConstructor(m2));
            } else {
                db.setConstructor(new QuickStartModuleConstructor(null)).setStrategy(Strategy.DEFAULT);
            }
            this.moduleContainer = ((DiscoveryModuleContainer.Builder)((DiscoveryModuleContainer.Builder)((DiscoveryModuleContainer.Builder)((DiscoveryModuleContainer.Builder)((DiscoveryModuleContainer.Builder)((DiscoveryModuleContainer.Builder)((DiscoveryModuleContainer.Builder)((DiscoveryModuleContainer.Builder)((DiscoveryModuleContainer.Builder)((DiscoveryModuleContainer.Builder)((DiscoveryModuleContainer.Builder)((DiscoveryModuleContainer.Builder)db.setConfigurationLoader((ConfigurationLoader<ConfigurationNode>)((HoconConfigurationLoader.Builder)builder.setDefaultOptions(ConfigurateHelper.setOptions(builder.getDefaultOptions()).setHeader(he))).build())).setPackageToScan(this.getClass().getPackage().getName() + ".modules").setLoggerProxy(new NucleusLoggerProxy(this.logger))).setConfigurationOptionsTransformer(x -> ConfigurateHelper.setOptions(x).setHeader(he))).setOnPreEnable(() -> {
                this.initDocGenIfApplicable();
                Sponge.getEventManager().post((Event)new BaseModuleEvent.AboutToEnable(this));
            })).setOnEnable(() -> Sponge.getEventManager().post((Event)new BaseModuleEvent.PreEnable(this)))).setOnPostEnable(() -> Sponge.getEventManager().post((Event)new BaseModuleEvent.Enabled(this)))).setRequireModuleDataAnnotation(true)).setNoMergeIfPresent(true)).setModuleConfigurationHeader(m -> {
                int i;
                StringBuilder ssb = new StringBuilder().append(divider).append("\n");
                String name = m.getClass().getAnnotation(ModuleData.class).name();
                int nameLength = name.length() + 2;
                int dashes = (length - nameLength) / 2;
                ssb.append("|");
                for (i = 0; i < dashes; ++i) {
                    ssb.append(" ");
                }
                ssb.append(" ").append(name).append(" ");
                for (i = 0; i < dashes; ++i) {
                    ssb.append(" ");
                }
                if (length > dashes * 2 + nameLength) {
                    ssb.append(" ");
                }
                return ssb.append("|").append("\n").append(divider).toString();
            })).setModuleConfigSectionName("-modules")).setModuleConfigSectionDescription(this.messageProvider.getMessageWithFormat("config.module-desc", new String[0]))).setModuleDescriptionHandler(m -> this.messageProvider.getMessageWithFormat("config.module." + m.getAnnotation(ModuleData.class).id().toLowerCase() + ".desc", new String[0]))).build();
            this.moduleContainer.startDiscover();
        }
        catch (Exception e) {
            this.isErrored = e;
            this.disable();
            e.printStackTrace();
        }
    }

    @Listener(order=Order.FIRST)
    public void onInit(GameInitializationEvent event) {
        if (this.isErrored != null) {
            return;
        }
        this.logger.info(this.messageProvider.getMessageWithFormat("startup.init", "Nucleus"));
        try {
            CatalogTypeFinalStaticProcessor.setEventContexts();
        }
        catch (Exception e) {
            this.isErrored = e;
            this.disable();
            e.printStackTrace();
        }
    }

    @Listener(order=Order.POST)
    public void onInitLate(GameInitializationEvent event) {
        if (this.isErrored != null) {
            return;
        }
        this.logger.info(this.messageProvider.getMessageWithFormat("startup.postinit", "Nucleus"));
        try {
            this.moduleContainer.reloadSystemConfig();
        }
        catch (Exception e) {
            this.isErrored = e;
            this.disable();
            e.printStackTrace();
            return;
        }
        try {
            Sponge.getEventManager().post((Event)new BaseModuleEvent.AboutToConstructEvent(this));
            this.logger.info(this.messageProvider.getMessageWithFormat("startup.moduleloading", "Nucleus"));
            this.moduleContainer.loadModules(true);
            CoreConfig coreConfig = (CoreConfig)this.moduleContainer.getConfigAdapterForModule("core", CoreConfigAdapter.class).getNodeOrDefault();
            if (coreConfig.isErrorOnStartup()) {
                throw new IllegalStateException("In main.conf, core.simulate-error-on-startup is set to TRUE. Remove this config entry to allow Nucleus to start. Simulating error and disabling Nucleus.");
            }
            this.isDebugMode = coreConfig.isDebugmode();
            this.isTraceUserCreations = coreConfig.traceUserCreations();
            this.savesandloads = coreConfig.isPrintSaveLoad();
        }
        catch (Throwable construction) {
            this.logger.info(this.messageProvider.getMessageWithFormat("startup.modulenotloaded", "Nucleus"));
            construction.printStackTrace();
            this.disable();
            this.isErrored = construction;
            return;
        }
        CommandPermissionHandler.onReload();
        this.registerReloadable(CommandPermissionHandler::onReload);
        this.getDocGenCache().ifPresent(x -> x.addTokenDocs(this.nucleusChatService.getNucleusTokenParser().getTokenNames()));
        this.logMessageDefault();
        this.logger.info(this.messageProvider.getMessageWithFormat("startup.moduleloaded", "Nucleus"));
        PermissionResolverImpl.INSTANCE.registerPermissions();
        this.registerReloadable(this::reloadPerm);
        this.reloadPerm();
        Sponge.getEventManager().post((Event)new BaseModuleEvent.Complete(this));
        this.logger.info(this.messageProvider.getMessageWithFormat("startup.completeinit", "Nucleus"));
    }

    @Listener(order=Order.EARLY)
    public void onGameStartingEarly(GameStartingServerEvent event) {
        if (!this.isServer) {
            try {
                this.logger.info(this.messageProvider.getMessageWithFormat("startup.loaddata", "Nucleus"));
                this.allChange();
            }
            catch (IOException e) {
                this.isErrored = e;
                this.disable();
                e.printStackTrace();
            }
        }
    }

    private void allChange() throws IOException {
        this.resetDataPath(true);
        this.generalService.changeFile();
        this.kitService.changeFile();
        this.nameBanService.changeFile();
        this.userCacheService.changeFile();
        this.userCacheService.load();
        this.nameBanService.load();
    }

    @Listener
    public void onGameStarting(GameStartingServerEvent event) {
        if (this.isErrored == null) {
            this.logger.info(this.messageProvider.getMessageWithFormat("startup.gamestart", "Nucleus"));
            try {
                this.kitService.loadInternal();
            }
            catch (Exception e) {
                this.isErrored = e;
                this.disable();
                e.printStackTrace();
                return;
            }
            Task.builder().async().execute(() -> this.userCacheService.startFilewalkIfNeeded()).submit((Object)this);
            this.logger.info(this.messageProvider.getMessageWithFormat("startup.started", "Nucleus"));
        }
    }

    @Listener
    public void onGameStarted(GameStartedServerEvent event) {
        if (!this.isServer) {
            try {
                Sponge.getServer().setHasWhitelist(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.isErrored == null) {
            this.generalService.getTransient(UniqueUserCountTransientModule.class).resetUniqueUserCount();
            try {
                this.getInternalServiceManager().getServiceUnchecked(UUIDChangeService.class).setStateAndReload();
                this.getInternalServiceManager().getServiceUnchecked(CommandRemapperService.class).activate();
                this.generalService.loadInternal();
                this.moduleContainer.refreshSystemConfig();
                this.fireReloadables();
            }
            catch (Throwable e) {
                this.isErrored = e;
                this.disable();
                this.errorOnStartup();
                return;
            }
            this.hasStarted = true;
            Sponge.getScheduler().createSyncExecutor((Object)this).submit(() -> {
                this.gameStartedTime = Instant.now();
                return this.gameStartedTime;
            });
            if (((CoreConfig)this.getInternalServiceManager().getService(CoreConfigAdapter.class).get().getNodeOrDefault()).isWarningOnStartup()) {
                ArrayList lt = Lists.newArrayList();
                if (ServiceChangeListener.isOpOnly()) {
                    this.addTri(lt);
                    lt.add(this.messageProvider.getTextMessageWithFormat("standard.line", new String[0]));
                    lt.add(this.messageProvider.getTextMessageWithFormat("standard.nopermplugin", new String[0]));
                    lt.add(this.messageProvider.getTextMessageWithFormat("standard.nopermplugin2", new String[0]));
                }
                if (!Sponge.getServiceManager().isRegistered(EconomyService.class)) {
                    if (lt.isEmpty()) {
                        this.addTri(lt);
                    }
                    lt.add(this.messageProvider.getTextMessageWithFormat("standard.line", new String[0]));
                    lt.add(this.messageProvider.getTextMessageWithFormat("standard.noeconplugin", new String[0]));
                    lt.add(this.messageProvider.getTextMessageWithFormat("standard.noeconplugin2", new String[0]));
                }
                if (!lt.isEmpty()) {
                    lt.add(this.messageProvider.getTextMessageWithFormat("standard.line", new String[0]));
                    lt.add(this.messageProvider.getTextMessageWithFormat("standard.seesuggested", new String[0]));
                }
                if (!this.startupMessages.isEmpty()) {
                    if (lt.isEmpty()) {
                        this.addTri(lt);
                    }
                    lt.add(this.messageProvider.getTextMessageWithFormat("standard.line", new String[0]));
                    lt.addAll(this.startupMessages);
                    this.startupMessages.clear();
                }
                if (!lt.isEmpty()) {
                    lt.add(this.messageProvider.getTextMessageWithFormat("standard.line", new String[0]));
                    ConsoleSource c = Sponge.getServer().getConsole();
                    lt.forEach(arg_0 -> ((ConsoleSource)c).sendMessage(arg_0));
                }
            }
        }
    }

    @Listener
    public void onServerStop(GameStoppedServerEvent event) {
        if (this.hasStarted && this.isErrored == null) {
            this.gameStartedTime = null;
            this.logger.info(this.messageProvider.getMessageWithFormat("startup.stopped", "Nucleus"));
            this.saveData();
            this.getInternalServiceManager().getServiceUnchecked(CommandRemapperService.class).deactivate();
        }
    }

    @Override
    public void saveData() {
        this.userDataManager.saveAll();
        this.worldDataManager.saveAll();
        if (Sponge.getGame().getState().ordinal() > GameState.SERVER_ABOUT_TO_START.ordinal()) {
            try {
                this.generalService.save();
                this.nameBanService.save();
                this.userCacheService.save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public Path getConfigDirPath() {
        return this.configDir;
    }

    private Path resetDataPath(boolean tryCreate) throws IOException {
        Path path;
        boolean custom = false;
        if (this.dataFileLocation == null) {
            path = this.dataDir.get();
        } else {
            custom = true;
            path = this.dataFileLocation.isAbsolute() ? this.dataFileLocation : this.dataDir.get().resolve(this.dataFileLocation);
            if (!Files.isDirectory(path, new LinkOption[0])) {
                this.logger.error(this.getMessageProvider().getMessageWithFormat("nucleus.custompath.error", path.toAbsolutePath().toString(), this.dataDir.get().toAbsolutePath().toString()));
                custom = false;
                path = this.dataDir.get();
            }
        }
        this.currentDataDir = path.resolve("nucleus");
        if (tryCreate) {
            if (custom) {
                this.logger.info(this.getMessageProvider().getMessageWithFormat("nucleus.custompath.info", this.currentDataDir.toAbsolutePath().toString()));
            }
            Files.createDirectories(this.currentDataDir, new FileAttribute[0]);
        }
        return this.currentDataDir;
    }

    @Override
    @Nonnull
    public Path getDataPath() {
        if (this.currentDataDir == null) {
            try {
                return this.resetDataPath(true);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.logger.error(this.getMessageProvider().getMessageWithFormat("nucleus.couldntcreate", new String[0]));
                try {
                    return this.resetDataPath(false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.currentDataDir;
    }

    @Override
    public UserDataManager getUserDataManager() {
        return this.userDataManager;
    }

    @Override
    public WorldDataManager getWorldDataManager() {
        return this.worldDataManager;
    }

    @Override
    public UserCacheService getUserCacheService() {
        return this.userCacheService;
    }

    @Override
    public void saveSystemConfig() throws IOException {
        this.moduleContainer.saveSystemConfig();
    }

    @Override
    public synchronized boolean reload() {
        try {
            this.moduleContainer.reloadSystemConfig();
            this.reloadMessages();
            this.commandsConfig.load();
            this.itemDataService.load();
            this.warmupConfig = null;
            CoreConfig coreConfig = (CoreConfig)this.getInternalServiceManager().getService(CoreConfigAdapter.class).get().getNodeOrDefault();
            this.isDebugMode = coreConfig.isDebugmode();
            this.isTraceUserCreations = coreConfig.traceUserCreations();
            this.savesandloads = coreConfig.isPrintSaveLoad();
            for (TextFileController tfc : this.textFileControllers.values()) {
                tfc.load();
            }
            this.fireReloadables();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void fireReloadables() throws Exception {
        for (Reloadable r : this.reloadableList) {
            r.onReload();
        }
    }

    private void reloadPerm() {
        this.permissionResolver = ((CoreConfig)this.getInternalServiceManager().getServiceUnchecked(CoreConfigAdapter.class).getNodeOrDefault()).isUseParentPerms() ? PermissionResolverImpl.INSTANCE : PermissionResolver.SIMPLE;
    }

    @Override
    public boolean reloadMessages() {
        boolean r = true;
        CoreConfig config = (CoreConfig)this.getInternalServiceManager().getServiceUnchecked(CoreConfigAdapter.class).getNodeOrDefault();
        String language = config.getServerLocale();
        if (language == null) {
            language = "default";
        }
        if (config.isCustommessages()) {
            try {
                this.messageProvider = new ConfigMessageProvider(this.configDir.resolve("messages.conf"), "assets.nucleus.messages", language);
                this.commandMessageProvider = new ConfigMessageProvider(this.configDir.resolve("command-help-messages.conf"), "assets.nucleus.commands", language);
                Sponge.getServer().getConsole().sendMessage(this.messageProvider.getTextMessageWithFormat("language.set", "messages.conf"));
                return true;
            }
            catch (Throwable exception) {
                r = false;
                if (exception instanceof IOException && exception.getCause().getClass().getName().contains(ConfigException.class.getSimpleName())) {
                    Object s = Sponge.getGame().isServerAvailable() ? Sponge.getServer().getConsole() : new ClientMessageReciever();
                    exception = exception.getCause();
                    s.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "It appears that there is an error in your messages file! The error is: "}));
                    s.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, exception.getMessage()}));
                    s.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Please correct this - then run ", TextColors.YELLOW, "/nucleus reload"}));
                    s.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Ignoring messages.conf for now."}));
                    if (this.isDebugMode) {
                        exception.printStackTrace();
                    }
                }
                this.logger.warn("Could not load custom messages file. Falling back.");
                exception.printStackTrace();
            }
        }
        this.messageProvider = new ResourceMessageProvider("assets.nucleus.messages", language);
        this.commandMessageProvider = new ResourceMessageProvider("assets.nucleus.commands", language);
        if (this.hasStarted) {
            this.logMessageDefault();
        }
        return r;
    }

    private void logMessageDefault() {
        this.logger.info(this.messageProvider.getMessageWithFormat("language.set", this.messageProvider.getLocale().toLanguageTag()));
    }

    @Override
    public WarmupManager getWarmupManager() {
        return this.warmupManager;
    }

    @Override
    public WarmupConfig getWarmupConfig() {
        if (this.warmupConfig == null) {
            this.warmupConfig = this.getConfigValue("core", CoreConfigAdapter.class, CoreConfig::getWarmupConfig).orElseGet(WarmupConfig::new);
        }
        return this.warmupConfig;
    }

    @Override
    public EconHelper getEconHelper() {
        return this.econHelper;
    }

    @Override
    public PermissionRegistry getPermissionRegistry() {
        return this.permissionRegistry;
    }

    @Override
    public DiscoveryModuleContainer getModuleContainer() {
        return this.moduleContainer;
    }

    @Override
    public boolean isModuleLoaded(String moduleId) {
        try {
            return this.getModuleContainer().isModuleLoaded(moduleId);
        }
        catch (NoModuleException e) {
            return false;
        }
    }

    public <R extends NucleusConfigAdapter<?>> Optional<R> getConfigAdapter(String id, Class<R> configAdapterClass) {
        try {
            return Optional.of(this.getModuleContainer().getConfigAdapterForModule(id, configAdapterClass));
        }
        catch (IncorrectAdapterTypeException | NoModuleException e) {
            return Optional.empty();
        }
    }

    @Override
    public InternalServiceManager getInternalServiceManager() {
        return this.serviceManager;
    }

    @Override
    public Optional<Instant> getGameStartedTime() {
        return Optional.ofNullable(this.gameStartedTime);
    }

    @Override
    public ModularGeneralService getGeneralService() {
        return this.generalService;
    }

    @Override
    public ItemDataService getItemDataService() {
        return this.itemDataService;
    }

    @Override
    public KitService getKitService() {
        return this.kitService;
    }

    @Override
    public NameBanService getNameBanService() {
        return this.nameBanService;
    }

    @Override
    public CommandsConfig getCommandsConfig() {
        return this.commandsConfig;
    }

    @Override
    public NameUtil getNameUtil() {
        return this.nameUtil;
    }

    @Override
    public TextParsingUtils getTextParsingUtils() {
        return this.textParsingUtils;
    }

    @Override
    public MessageProvider getMessageProvider() {
        return this.messageProvider;
    }

    @Override
    public MessageProvider getCommandMessageProvider() {
        return this.commandMessageProvider;
    }

    @Override
    public NucleusTeleportHandler getTeleportHandler() {
        return this.teleportHandler;
    }

    @Override
    public NucleusMessageTokenService getMessageTokenService() {
        return this.nucleusChatService;
    }

    @Override
    public boolean isDebugMode() {
        return this.isDebugMode || this.sessionDebugMode;
    }

    @Override
    public void printStackTraceIfDebugMode(Throwable throwable) {
        if (this.isDebugMode()) {
            throwable.printStackTrace();
        }
    }

    @Override
    public int traceUserCreations() {
        return this.isTraceUserCreations;
    }

    @Override
    public Optional<TextFileController> getTextFileController(String getController) {
        return Optional.ofNullable(this.textFileControllers.get(getController));
    }

    @Override
    public void addTextFileController(String id, Asset asset, Path file) throws IOException {
        if (!this.textFileControllers.containsKey(id)) {
            this.textFileControllers.put(id, new TextFileController(asset, file));
        }
    }

    @Override
    public void registerReloadable(Reloadable reloadable) {
        this.reloadableList.add(reloadable);
    }

    @Override
    public Optional<DocGenCache> getDocGenCache() {
        return Optional.ofNullable(this.docGenCache);
    }

    @Override
    public PluginContainer getPluginContainer() {
        return this.pluginContainer;
    }

    @Override
    public boolean isSessionDebug() {
        return this.sessionDebugMode;
    }

    @Override
    public void setSessionDebug(boolean debug) {
        this.sessionDebugMode = debug;
    }

    private void initDocGenIfApplicable() {
        if (this.moduleContainer.getCurrentPhase() == ConstructionPhase.ENABLING) {
            try {
                if (((CoreConfig)this.moduleContainer.getConfigAdapterForModule("core", CoreConfigAdapter.class).getNodeOrDefault()).isEnableDocGen()) {
                    this.docGenCache = new DocGenCache(this.logger);
                }
            }
            catch (IncorrectAdapterTypeException | NoModuleException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public PermissionResolver getPermissionResolver() {
        return this.permissionResolver;
    }

    @Override
    public boolean isServer() {
        return this.isServer;
    }

    @Override
    public void addStartupMessage(Text message) {
        this.startupMessages.add(message);
    }

    @Override
    public boolean isPrintingSavesAndLoads() {
        return this.savesandloads;
    }

    private void disable() {
        Sponge.getEventManager().unregisterPluginListeners((Object)this);
        Sponge.getCommandManager().getOwnedBy((Object)this).forEach(arg_0 -> ((CommandManager)Sponge.getCommandManager()).removeMapping(arg_0));
        Sponge.getScheduler().getScheduledTasks((Object)this).forEach(Task::cancel);
        this.getInternalServiceManager().getService(CommandRemapperService.class).ifPresent(CommandRemapperService::deactivate);
        Sponge.getEventManager().registerListener((Object)this, GameStartedServerEvent.class, e -> this.errorOnStartup());
    }

    private void errorOnStartup() {
        try {
            Sponge.getServer().setHasWhitelist(!this.isServer);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.versionFail != null) {
            Sponge.getServer().getConsole().sendMessages(this.getIncorrectVersion());
        } else {
            Sponge.getServer().getConsole().sendMessages(this.getErrorMessage());
        }
    }

    private List<Text> getIncorrectVersion() {
        ArrayList messages = Lists.newArrayList();
        messages.add(Text.of((Object[])new Object[]{TextColors.RED, "------------------------------"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.RED, "-   NUCLEUS FAILED TO LOAD   -"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.RED, "------------------------------"}));
        this.addX(messages, 7);
        messages.add(Text.of((Object[])new Object[]{TextColors.RED, "------------------------------"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.RED, "-  INCORRECT SPONGE VERSION  -"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.RED, "------------------------------"}));
        messages.add(Text.EMPTY);
        messages.add(Text.of((Object[])new Object[]{TextColors.RED, "You are a mismatched version of Sponge on your server - this version of Nucleus will not run upon it."}));
        messages.add(Text.of((Object[])new Object[]{TextColors.RED, "Nucleus has not started. Update Sponge to the latest version and try again."}));
        if (this.isServer) {
            messages.add(Text.of((Object[])new Object[]{TextColors.RED, "The server has been automatically whitelisted - this is to protect your server and players if you rely on some of Nucleus' functionality (such as fly states, etc.)"}));
        }
        messages.add(Text.of((Object[])new Object[]{TextColors.RED, "------------------------------"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "Reason: "}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, this.versionFail}));
        messages.add(Text.of((Object[])new Object[]{TextColors.RED, "------------------------------"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "Current Sponge Implementation: ", Sponge.getPlatform().getContainer(Platform.Component.IMPLEMENTATION).getName(), ", version ", Sponge.getPlatform().getContainer(Platform.Component.IMPLEMENTATION).getVersion().orElse("unknown"), "."}));
        return messages;
    }

    private void addTri(List<Text> messages) {
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "        /\\"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "       /  \\"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "      / || \\"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "     /  ||  \\"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "    /   ||   \\"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "   /    ||    \\"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "  /            \\"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, " /      **      \\"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "------------------"}));
    }

    @Override
    public void addX(List<Text> messages, int spacing) {
        LiteralText space = Text.of((String)String.join((CharSequence)"", Collections.nCopies(spacing, " ")));
        messages.add(Text.of((Object[])new Object[]{space, TextColors.RED, "\\              /"}));
        messages.add(Text.of((Object[])new Object[]{space, TextColors.RED, " \\            /"}));
        messages.add(Text.of((Object[])new Object[]{space, TextColors.RED, "  \\          /"}));
        messages.add(Text.of((Object[])new Object[]{space, TextColors.RED, "   \\        /"}));
        messages.add(Text.of((Object[])new Object[]{space, TextColors.RED, "    \\      /"}));
        messages.add(Text.of((Object[])new Object[]{space, TextColors.RED, "     \\    /"}));
        messages.add(Text.of((Object[])new Object[]{space, TextColors.RED, "      \\  /"}));
        messages.add(Text.of((Object[])new Object[]{space, TextColors.RED, "       \\/"}));
        messages.add(Text.of((Object[])new Object[]{space, TextColors.RED, "       /\\"}));
        messages.add(Text.of((Object[])new Object[]{space, TextColors.RED, "      /  \\"}));
        messages.add(Text.of((Object[])new Object[]{space, TextColors.RED, "     /    \\"}));
        messages.add(Text.of((Object[])new Object[]{space, TextColors.RED, "    /      \\"}));
        messages.add(Text.of((Object[])new Object[]{space, TextColors.RED, "   /        \\"}));
        messages.add(Text.of((Object[])new Object[]{space, TextColors.RED, "  /          \\"}));
        messages.add(Text.of((Object[])new Object[]{space, TextColors.RED, " /            \\"}));
        messages.add(Text.of((Object[])new Object[]{space, TextColors.RED, "/              \\"}));
    }

    private List<Text> getErrorMessage() {
        ArrayList messages = Lists.newArrayList();
        messages.add(Text.of((Object[])new Object[]{TextColors.RED, "----------------------------"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.RED, "-  NUCLEUS FAILED TO LOAD  -"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.RED, "----------------------------"}));
        this.addX(messages, 5);
        messages.add(Text.of((Object[])new Object[]{TextColors.RED, "----------------------------"}));
        messages.add(Text.EMPTY);
        messages.add(Text.of((Object[])new Object[]{TextColors.RED, "Nucleus encountered an error during server start up and did not enable successfully. No commands, listeners or tasks are registered."}));
        if (this.isServer) {
            messages.add(Text.of((Object[])new Object[]{TextColors.RED, "The server has been automatically whitelisted - this is to protect your server and players if you rely on some of Nucleus' functionality (such as fly states, etc.)"}));
        }
        messages.add(Text.of((Object[])new Object[]{TextColors.RED, "The error that Nucleus encountered will be reproduced below for your convenience."}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "----------------------------"}));
        if (this.isErrored == null) {
            messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "No exception was saved."}));
        } else {
            Throwable exception = this.isErrored;
            if (exception.getCause() != null && (exception instanceof QuickStartModuleLoaderException || exception instanceof QuickStartModuleDiscoveryException)) {
                exception = exception.getCause();
            }
            if (exception instanceof IOException && exception.getCause().getClass().getName().contains(ConfigException.class.getSimpleName())) {
                exception = exception.getCause();
                messages.add(Text.of((Object[])new Object[]{TextColors.RED, "It appears that there is an error in your configuration file! The error is: "}));
                messages.add(Text.of((Object[])new Object[]{TextColors.RED, exception.getMessage()}));
                messages.add(Text.of((Object[])new Object[]{TextColors.RED, "Please correct this and restart your server."}));
                messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "----------------------------"}));
                messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "(The error that was thrown is shown below)"}));
            }
            try (StringWriter sw = new StringWriter();
                 PrintWriter pw = new PrintWriter(sw);){
                String[] stackTrace;
                exception.printStackTrace(pw);
                pw.flush();
                for (String s : stackTrace = sw.toString().split("(\r)?\n")) {
                    messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, s}));
                }
            }
            catch (IOException e) {
                exception.printStackTrace();
            }
        }
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "----------------------------"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.RED, "If this error persists, check your configuration files and ensure that you have the latest version of Nucleus which matches the current version of the Sponge API."}));
        messages.add(Text.of((Object[])new Object[]{TextColors.RED, "If you do, please report this error to the Nucleus team at https://github.com/NucleusPowered/Nucleus/issues"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "----------------------------"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "Server Information"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "----------------------------"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "Nucleus version: 1.9.2-S7.1, (Git: 4ee67592)"}));
        Platform platform = Sponge.getPlatform();
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "Minecraft version: " + platform.getMinecraftVersion().getName()}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, String.format("Sponge Version: %s %s", platform.getContainer(Platform.Component.IMPLEMENTATION).getName(), platform.getContainer(Platform.Component.IMPLEMENTATION).getVersion().orElse("unknown"))}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, String.format("Sponge API Version: %s %s", platform.getContainer(Platform.Component.API).getName(), platform.getContainer(Platform.Component.API).getVersion().orElse("unknown"))}));
        messages.add(Text.EMPTY);
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "----------------------------"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "Installed Plugins"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "----------------------------"}));
        Sponge.getPluginManager().getPlugins().forEach(x -> messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, x.getName() + " (" + x.getId() + ") version " + x.getVersion().orElse("unknown")})));
        messages.add(Text.EMPTY);
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "----------------------------"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "- END NUCLEUS ERROR REPORT -"}));
        messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, "----------------------------"}));
        return messages;
    }
}

