/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.api.service;

import com.flowpowered.math.vector.Vector3d;
import io.github.nucleuspowered.nucleus.api.exceptions.NoSuchPlayerException;
import io.github.nucleuspowered.nucleus.api.exceptions.NucleusException;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Home;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public interface NucleusHomeService {
    public static final String DEFAULT_HOME_NAME = "home";
    public static final Pattern HOME_NAME_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9]{1,15}$");

    default public int getHomeCount(UUID user) {
        return this.getHomes(user).size();
    }

    default public int getHomeCount(User user) {
        return this.getHomeCount(user.getUniqueId());
    }

    public List<Home> getHomes(UUID var1);

    default public List<Home> getHomes(User user) {
        return this.getHomes(user.getUniqueId());
    }

    public Optional<Home> getHome(UUID var1, String var2);

    default public Optional<Home> getHome(User user, String name) {
        return this.getHome(user.getUniqueId(), name);
    }

    public void createHome(Cause var1, User var2, String var3, Location<World> var4, Vector3d var5) throws NucleusException;

    default public void createHome(Cause cause, UUID user, String name, Location<World> location, Vector3d rotation) throws NucleusException, NoSuchPlayerException {
        this.createHome(cause, (User)((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(user).orElseThrow(NoSuchPlayerException::new), name, location, rotation);
    }

    default public void modifyHome(Cause cause, UUID user, String name, Location<World> location, Vector3d rotation) throws NucleusException {
        this.modifyHome(cause, this.getHome(user, name).orElseThrow(() -> new NucleusException((Text)Text.of((String)"Home does not exist"), NucleusException.ExceptionType.DOES_NOT_EXIST)), location, rotation);
    }

    public void modifyHome(Cause var1, Home var2, Location<World> var3, Vector3d var4) throws NucleusException;

    default public void modifyHome(Cause cause, User user, String name, Location<World> location, Vector3d rotation) throws NucleusException {
        this.modifyHome(cause, user.getUniqueId(), name, location, rotation);
    }

    default public void modifyOrCreateHome(Cause cause, User user, String name, Location<World> location, Vector3d rotation) throws NucleusException {
        if (this.getHome(user, name).isPresent()) {
            this.modifyHome(cause, user, name, location, rotation);
        } else {
            this.createHome(cause, user, name, location, rotation);
        }
    }

    default public void modifyOrCreateHome(Cause cause, UUID user, String name, Location<World> location, Vector3d rotation) throws NucleusException, NoSuchPlayerException {
        this.modifyOrCreateHome(cause, (User)((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(user).orElseThrow(NoSuchPlayerException::new), name, location, rotation);
    }

    default public void removeHome(Cause cause, UUID user, String name) throws NucleusException {
        this.removeHome(cause, this.getHome(user, name).orElseThrow(() -> new NucleusException((Text)Text.of((String)"Home does not exist"), NucleusException.ExceptionType.DOES_NOT_EXIST)));
    }

    public void removeHome(Cause var1, Home var2) throws NucleusException;

    public int getMaximumHomes(UUID var1) throws IllegalArgumentException;

    public int getMaximumHomes(User var1);
}

