/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.api.service;

import com.google.common.base.Preconditions;
import io.github.nucleuspowered.nucleus.api.exceptions.NucleusException;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public interface NucleusServerShopService {
    public Map<CatalogType, Double> getBuyPrices();

    public Map<CatalogType, Double> getSellPrices();

    default public Optional<Double> getBuyPrice(ItemType type) {
        Preconditions.checkNotNull((Object)type);
        return this.getBuyPrice(ItemStack.of((ItemType)type, (int)1));
    }

    public Optional<Double> getBuyPrice(BlockState var1) throws NucleusException;

    default public Optional<Double> getBuyPrice(ItemStack itemStack) {
        Preconditions.checkNotNull((Object)itemStack);
        return this.getBuyPrice(itemStack.createSnapshot());
    }

    public Optional<Double> getBuyPrice(ItemStackSnapshot var1);

    default public Optional<Double> getSellPrice(ItemType type) {
        Preconditions.checkNotNull((Object)type);
        return this.getSellPrice(ItemStack.of((ItemType)type, (int)1));
    }

    public Optional<Double> getSellPrice(BlockState var1) throws NucleusException;

    default public Optional<Double> getSellPrice(ItemStack itemStack) {
        Preconditions.checkNotNull((Object)itemStack);
        return this.getSellPrice(itemStack.createSnapshot());
    }

    public Optional<Double> getSellPrice(ItemStackSnapshot var1);
}

