/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.argumentparsers;

import com.google.common.collect.ImmutableList;
import io.github.nucleuspowered.nucleus.Nucleus;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;

public class BoundedDoubleArgument
extends CommandElement {
    private static final NumberFormat formatter = new DecimalFormat("#0.00");
    private final double min;
    private final double max;

    public BoundedDoubleArgument(@Nullable Text key, double min, double max) {
        super(key);
        this.min = Math.min(min, max);
        this.max = Math.max(min, max);
    }

    @Nullable
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        try {
            double value = Double.parseDouble(args.next());
            if (value > this.max || value < this.min) {
                throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.boundedinteger.outofbounds", String.valueOf(this.min), String.valueOf(this.max)));
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.boundedinteger.nonumber", new String[0]));
        }
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        return ImmutableList.of();
    }

    public Text getUsage(CommandSource src) {
        return Text.of((Object[])new Object[]{this.getKey(), String.format("(%s to %s)", formatter.format(this.min), formatter.format(this.max))});
    }
}

