/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.argumentparsers;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Home;
import io.github.nucleuspowered.nucleus.modules.home.datamodules.HomeUserDataModule;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public class HomeArgument
extends CommandElement {
    private final Nucleus plugin;

    public HomeArgument(@Nullable Text key, Nucleus plugin) {
        super(key);
        this.plugin = plugin;
    }

    @Nullable
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        if (!(source instanceof User)) {
            throw args.createError(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.playeronly", new String[0]));
        }
        return this.getHome((User)source, args.next(), args);
    }

    Home getHome(User user, String home, CommandArgs args) throws ArgumentParseException {
        try {
            Optional<Home> owl = Nucleus.getNucleus().getUserDataManager().getUnchecked(user).get(HomeUserDataModule.class).getHome(home);
            if (owl.isPresent()) {
                return owl.get();
            }
        }
        catch (Exception e) {
            if (this.plugin.isDebugMode()) {
                e.printStackTrace();
            }
            throw args.createError(Text.of((Object[])new Object[]{TextColors.RED, "An unspecified error occurred"}));
        }
        throw args.createError(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("args.home.nohome", home));
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        if (!(src instanceof User)) {
            return Lists.newArrayList();
        }
        User u = (User)src;
        try {
            return this.complete(u, args.peek());
        }
        catch (ArgumentParseException e) {
            return this.complete(u, "");
        }
    }

    protected List<String> complete(User src, String homeName) {
        Set<String> s;
        try {
            s = Nucleus.getNucleus().getUserDataManager().getUnchecked(src).get(HomeUserDataModule.class).getHomes().keySet();
        }
        catch (Exception e) {
            return Lists.newArrayList();
        }
        String name = homeName.toLowerCase();
        return s.stream().filter(x -> x.toLowerCase().startsWith(name)).limit(20L).collect(Collectors.toList());
    }
}

