/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.argumentparsers;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.argumentparsers.HomeArgument;
import io.github.nucleuspowered.nucleus.argumentparsers.NicknameArgument;
import io.github.nucleuspowered.nucleus.internal.CommandPermissionHandler;
import io.github.nucleuspowered.nucleus.internal.traits.MessageProviderTrait;
import io.github.nucleuspowered.nucleus.modules.home.commands.HomeOtherCommand;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public class HomeOtherArgument
extends HomeArgument
implements MessageProviderTrait {
    private final NicknameArgument nickArg;
    private final CommandPermissionHandler reg;

    public HomeOtherArgument(@Nullable Text key, Nucleus plugin) {
        super(key, plugin);
        this.nickArg = new NicknameArgument(key, NicknameArgument.Target.USER);
        this.reg = plugin.getPermissionRegistry().getPermissionsForNucleusCommand(HomeOtherCommand.class);
    }

    @Override
    @Nullable
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        String player = args.next();
        Optional ohome = args.nextIfPresent();
        if (!ohome.isPresent()) {
            throw args.createError(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("args.homeother.notenough", new String[0]));
        }
        Set<?> users = this.nickArg.parseValue(source, player.toLowerCase(), (key, entry) -> args.createError(this.getMessageFor(source.getLocale(), (String)key, new String[]{entry})));
        if (users.size() != 1) {
            throw args.createError(this.getMessageFor(source.getLocale(), "args.homeother.ambiguous"));
        }
        User user = (User)users.iterator().next();
        if (this.reg.testSuffix((Subject)user, "exempt.target", source, false)) {
            throw args.createError(this.getMessageFor(source.getLocale(), "args.homeother.exempt"));
        }
        return this.getHome(user, (String)ohome.get(), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        Object saveState = null;
        try {
            saveState = args.getState();
            String arg1 = args.next();
            Optional arg2 = args.nextIfPresent();
            if (arg2.isPresent()) {
                Set<?> u = this.nickArg.parseValue(src, arg1.toLowerCase(), (key, entry) -> args.createError(this.getMessageFor(src.getLocale(), (String)key, new String[]{entry})));
                if (u.size() != 1) {
                    throw args.createError(this.getMessageFor(src.getLocale(), "args.homeother.ambiguous"));
                }
                User user = (User)u.iterator().next();
                List<String> list = this.complete(user, (String)arg2.get());
                return list;
            }
            args.setState(saveState);
            List<String> list = this.nickArg.complete(src, args, context);
            return list;
        }
        catch (Exception e) {
            if (Nucleus.getNucleus().isDebugMode()) {
                e.printStackTrace();
            }
        }
        finally {
            if (saveState != null) {
                args.setState(saveState);
            }
        }
        return Collections.emptyList();
    }

    public Text getUsage(CommandSource src) {
        return Text.of((String)"<user> <home>");
    }
}

