/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.argumentparsers;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.internal.traits.InternalServiceManagerTrait;
import io.github.nucleuspowered.nucleus.modules.message.services.MessageHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;

public class MessageTargetArgument
extends CommandElement
implements InternalServiceManagerTrait {
    private final MessageHandler messageHandler = (MessageHandler)this.getServiceUnchecked(MessageHandler.class);

    public MessageTargetArgument(@Nullable Text key) {
        super(key);
    }

    @Nullable
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        return this.messageHandler.getTarget(args.next().toLowerCase()).orElseThrow(() -> args.createError((Text)Text.of((String)"No bot exists with that name")));
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        ArrayList m = Lists.newArrayList((Iterable)this.messageHandler.getTargetNames().keySet());
        try {
            String a = args.peek().toLowerCase();
            return m.stream().filter(x -> x.startsWith(a)).collect(Collectors.toList());
        }
        catch (ArgumentParseException e) {
            return m;
        }
    }
}

