/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.argumentparsers;

import com.google.common.collect.ImmutableSet;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.traits.InternalServiceManagerTrait;
import io.github.nucleuspowered.nucleus.internal.traits.MessageProviderTrait;
import io.github.nucleuspowered.nucleus.internal.traits.PermissionTrait;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.nickname.services.NicknameService;
import io.github.nucleuspowered.nucleus.modules.vanish.commands.VanishCommand;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.Identifiable;

public class NicknameArgument
extends CommandElement
implements MessageProviderTrait,
InternalServiceManagerTrait,
PermissionTrait {
    private static boolean init = false;
    private static int USER_LIMIT = 20;
    private static final String VANISH_PERMISSION = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(VanishCommand.class).getPermissionWithSuffix("see");
    private static boolean PARTIAL_MATCH = true;
    private final Target target;
    @Nullable
    private final NicknameService nicknameService = this.getService(NicknameService.class).orElse(null);

    public static void onReload() {
        CoreConfig cc = (CoreConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(CoreConfigAdapter.class).getNodeOrDefault();
        USER_LIMIT = Math.max(cc.getNicknameArgOfflineLimit(), 0);
        PARTIAL_MATCH = cc.isPartialMatch();
    }

    public NicknameArgument(@Nullable Text key, Target target) {
        super(key);
        this.target = target;
        if (!init) {
            init = true;
            Nucleus.getNucleus().registerReloadable(NicknameArgument::onReload);
        }
    }

    @Nullable
    public Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        String toParse = args.next();
        return this.parseValue(source, toParse, (key, entry) -> args.createError(this.getMessageFor(source.getLocale(), (String)key, new String[]{entry})));
    }

    public Set<?> parseValue(CommandSource source, String toParse, BiFunction<String, String, ArgumentParseException> exceptionSupplier) throws ArgumentParseException {
        Optional<Player> op;
        Optional user;
        Optional player;
        if (this.target == Target.PLAYER_CONSOLE && toParse.equalsIgnoreCase("-")) {
            return ImmutableSet.of((Object)Sponge.getServer().getConsole());
        }
        Predicate<Player> shouldShow = this.determinePredicate(source);
        boolean playerOnly = toParse.startsWith("p:");
        if (playerOnly) {
            toParse = toParse.substring(2);
        }
        if ((player = Sponge.getServer().getPlayer(toParse)).isPresent() && NicknameArgument.shouldShowPlayer((Player)player.get())) {
            return ImmutableSet.of(player.get());
        }
        if (playerOnly) {
            throw exceptionSupplier.apply("args.user.nouser", toParse);
        }
        UserStorageService uss = (UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class);
        if (!toParse.isEmpty() && this.target == Target.USER && (user = uss.get(toParse)).isPresent()) {
            return ImmutableSet.of(user.get());
        }
        if (this.nicknameService != null && (op = this.nicknameService.getFromCache(toParse.toLowerCase())).isPresent() && NicknameArgument.shouldShowPlayer(op.get())) {
            return ImmutableSet.of((Object)op.get());
        }
        if (!PARTIAL_MATCH) {
            throw exceptionSupplier.apply("args.user.nouser", toParse);
        }
        if (toParse.length() < 3) {
            throw exceptionSupplier.apply("args.user.nouserfuzzy", toParse);
        }
        HashSet users = new HashSet();
        String parse = toParse.toLowerCase();
        Sponge.getServer().getOnlinePlayers().stream().filter(x -> x.getName().toLowerCase().startsWith(parse)).filter(shouldShow).limit(USER_LIMIT).forEach(users::add);
        if (this.nicknameService != null) {
            this.nicknameService.startsWith(parse).stream().map(x -> Sponge.getServer().getPlayer(x).orElse(null)).filter(shouldShow).filter(Objects::nonNull).limit(USER_LIMIT).forEach(users::add);
        }
        List uuids = users.stream().map(Identifiable::getUniqueId).collect(Collectors.toList());
        if (this.target == Target.USER) {
            if (PARTIAL_MATCH) {
                uss.match(parse).stream().map(x -> uss.get(x).orElse(null)).filter(Objects::nonNull).filter(x -> !uuids.contains(x.getUniqueId())).limit(USER_LIMIT).forEach(users::add);
            } else {
                uss.get(parse).filter(x -> !uuids.contains(x.getUniqueId())).ifPresent(users::add);
            }
        }
        if (users.isEmpty()) {
            throw exceptionSupplier.apply("args.user.nouser", toParse);
        }
        return ImmutableSet.copyOf(users);
    }

    public List<String> complete(CommandSource source, CommandArgs args, CommandContext context) {
        ArrayList<String> names = new ArrayList<String>();
        try {
            String toParse = args.peek();
            boolean playerOnly = toParse.startsWith("p:");
            if (playerOnly) {
                toParse = toParse.substring(2);
            }
            String parse = toParse.toLowerCase();
            Predicate<Player> shouldShow = this.determinePredicate(source);
            Predicate<Player> partial = x -> x.getName().toLowerCase().startsWith(parse);
            UserStorageService uss = (UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class);
            Sponge.getServer().getOnlinePlayers().stream().filter(partial.and(shouldShow)).forEach(player -> {
                if (playerOnly) {
                    names.add("p:" + player.getName());
                } else {
                    names.add(player.getName());
                }
            });
            if (!playerOnly) {
                if (this.nicknameService != null) {
                    this.nicknameService.startsWithGetMap(parse).entrySet().stream().map(x -> Sponge.getServer().getPlayer((UUID)x.getValue()).filter(shouldShow).map(y -> (String)x.getKey()).orElse(null)).filter(Objects::nonNull).forEach(names::add);
                }
                if (USER_LIMIT > 0 && this.target == Target.USER) {
                    uss.match(parse).stream().map(x -> uss.get(x).map(User::getName).orElse(null)).filter(Objects::nonNull).limit(USER_LIMIT).forEach(names::add);
                }
            }
            return names;
        }
        catch (ArgumentParseException ex) {
            return names;
        }
    }

    private Predicate<Player> determinePredicate(CommandSource source) {
        if (this.hasPermission((Subject)source, VANISH_PERMISSION)) {
            return p -> true;
        }
        return NicknameArgument::shouldShowPlayer;
    }

    private static boolean shouldShowPlayer(Player player) {
        return player.get(Keys.VANISH).orElse(false) == false;
    }

    public static enum Target {
        PLAYER,
        PLAYER_CONSOLE,
        USER;

    }
}

