/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.argumentparsers;

import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.modules.note.data.NoteData;
import io.github.nucleuspowered.nucleus.modules.note.services.NoteHandler;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;

public class NoteArgument
extends CommandElement {
    private final NoteHandler handler;

    public NoteArgument(@Nullable Text key, NoteHandler handler) {
        super(key);
        this.handler = handler;
    }

    @Nullable
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        int index;
        Optional optPlayer = args.nextIfPresent();
        if (!optPlayer.isPresent()) {
            throw args.createError(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("args.note.nouserarg", new String[0]));
        }
        String player = (String)optPlayer.get();
        Optional optUser = ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(player);
        if (!optUser.isPresent()) {
            throw args.createError(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("args.note.nouser", player));
        }
        User user = (User)optUser.get();
        Optional optIndex = args.nextIfPresent();
        if (!optIndex.isPresent()) {
            throw args.createError(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("args.note.noindex", user.getName()));
        }
        List<NoteData> noteData = this.handler.getNotesInternal(user);
        try {
            index = Integer.parseInt((String)optIndex.get()) - 1;
            if (index >= noteData.size() || index < 0) {
                throw args.createError(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("args.note.nonotedata", (String)optIndex.get(), user.getName()));
            }
        }
        catch (NumberFormatException ex) {
            throw args.createError(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("args.note.indexnotnumber", new String[0]));
        }
        return new Result(user, noteData.get(index));
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        return Collections.emptyList();
    }

    public Text getUsage(CommandSource src) {
        return Text.of((String)"<user> <ID>");
    }

    public static class Result {
        public final User user;
        public final NoteData noteData;

        public Result(User user, NoteData noteData) {
            this.user = user;
            this.noteData = noteData;
        }
    }
}

