/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.dataservices;

import com.google.common.base.Preconditions;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.dataservices.Service;
import io.github.nucleuspowered.nucleus.dataservices.dataproviders.DataProvider;

public abstract class AbstractService<T>
implements Service {
    protected T data;
    private final DataProvider<T> dataProvider;

    protected AbstractService(DataProvider<T> dataProvider) {
        this.dataProvider = (DataProvider)Preconditions.checkNotNull(dataProvider);
    }

    public final void changeFile() {
        if (this.dataProvider instanceof DataProvider.FileChanging) {
            ((DataProvider.FileChanging)this.dataProvider).onChange();
        }
    }

    public final boolean isLoaded() {
        return this.data != null;
    }

    protected abstract String serviceName();

    @Override
    public boolean load() {
        try {
            this.loadInternal();
            return true;
        }
        catch (Exception e) {
            Nucleus.getNucleus().getLogger().error("Could not load", (Throwable)e);
            return false;
        }
    }

    @Override
    public void loadInternal() throws Exception {
        if (Nucleus.getNucleus().isPrintingSavesAndLoads()) {
            Nucleus.getNucleus().getLogger().info("Loading: " + this.serviceName());
        }
        this.data = this.dataProvider.load();
    }

    @Override
    public boolean save() {
        try {
            this.saveInternal();
            return true;
        }
        catch (Exception e) {
            Nucleus.getNucleus().getLogger().error("Could not save", (Throwable)e);
            return false;
        }
    }

    @Override
    public void saveInternal() throws Exception {
        if (this.data != null) {
            if (Nucleus.getNucleus().isPrintingSavesAndLoads()) {
                Nucleus.getNucleus().getLogger().info("Saving: " + this.serviceName());
            }
            this.dataProvider.save(this.data);
            return;
        }
        throw new IllegalStateException("Data has not been initialised.");
    }

    @Override
    public boolean delete() {
        try {
            if (Nucleus.getNucleus().isPrintingSavesAndLoads()) {
                Nucleus.getNucleus().getLogger().info("Deleting: " + this.serviceName());
            }
            this.dataProvider.delete();
            return true;
        }
        catch (Exception e) {
            Nucleus.getNucleus().getLogger().error("Could not delete", (Throwable)e);
            return false;
        }
    }
}

