/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.dataservices;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.configurate.datatypes.ItemDataNode;
import io.github.nucleuspowered.nucleus.dataservices.AbstractService;
import io.github.nucleuspowered.nucleus.dataservices.dataproviders.DataProvider;
import io.github.nucleuspowered.nucleus.util.Action;
import io.github.nucleuspowered.nucleus.util.Tuples;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Tuple;

public class ItemDataService
extends AbstractService<Map<String, ItemDataNode>> {
    private Map<String, String> aliasToItemIdCache = null;
    private Map<CatalogType, Double> buyCache = null;
    private Map<CatalogType, Double> sellCache = null;
    private final Set<Action> onItemUpdate = Sets.newHashSet();

    public ItemDataService(DataProvider<Map<String, ItemDataNode>> dataProvider) {
        super(dataProvider);
    }

    public void addOnItemUpdate(Action onUpdate) {
        this.onItemUpdate.add(onUpdate);
    }

    @Override
    protected String serviceName() {
        return "Item Information";
    }

    @Override
    public boolean load() {
        if (super.load()) {
            this.clearCache();
            return true;
        }
        return false;
    }

    @Override
    public void saveInternal() throws Exception {
        this.clearCache();
        super.saveInternal();
    }

    public Set<String> getAliases() {
        return this.getCache().keySet();
    }

    public ItemDataNode getDataForItem(ItemStackSnapshot itemStackSnapshot) {
        return this.getDataForItem(this.getIdFromSnapshot(itemStackSnapshot));
    }

    public ItemDataNode getDataForItem(String id) {
        Preconditions.checkNotNull((Object)id);
        return ((Map)this.data).getOrDefault(id.toLowerCase(), new ItemDataNode());
    }

    public void setDataForItem(ItemStackSnapshot itemStackSnapshot, ItemDataNode node) {
        this.setDataForItem(this.getIdFromSnapshot(itemStackSnapshot), node);
    }

    public void setDataForItem(String id, ItemDataNode node) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)node);
        ((Map)this.data).put(id, node);
        this.save();
    }

    public void resetDataForItem(ItemStackSnapshot itemStackSnapshot) {
        this.resetDataForItem(this.getIdFromSnapshot(itemStackSnapshot));
    }

    private void resetDataForItem(String id) {
        Preconditions.checkNotNull((Object)id);
        ((Map)this.data).remove(id);
        this.save();
    }

    public Optional<String> getIdFromAlias(String alias) {
        return Optional.ofNullable(this.getCache().get(alias));
    }

    public Map<CatalogType, Double> getServerBuyPrices() {
        if (this.buyCache == null) {
            this.buyCache = ((Map)this.data).entrySet().stream().filter(x -> ((ItemDataNode)x.getValue()).getServerBuyPrice() >= 0.0).map(this::toCt).collect(Collectors.toMap(Tuple::getFirst, x -> ((ItemDataNode)x.getSecond()).getServerBuyPrice()));
        }
        return this.buyCache;
    }

    public Map<CatalogType, Double> getServerSellPrices() {
        if (this.sellCache == null) {
            this.sellCache = ((Map)this.data).entrySet().stream().filter(x -> ((ItemDataNode)x.getValue()).getServerSellPrice() >= 0.0).map(this::toCt).collect(Collectors.toMap(Tuple::getFirst, x -> ((ItemDataNode)x.getSecond()).getServerSellPrice()));
        }
        return this.sellCache;
    }

    private <T> Tuple<CatalogType, T> toCt(Map.Entry<String, T> x) {
        Optional<CatalogType> catalogType = Util.getCatalogTypeForItemFromId(x.getKey());
        return catalogType.map(catalogType1 -> Tuples.of(catalogType1, x.getValue())).orElseGet(() -> Tuples.of(ItemTypes.NONE, x.getValue()));
    }

    private Map<String, String> getCache() {
        if (this.aliasToItemIdCache == null) {
            this.aliasToItemIdCache = ((Map)this.data).entrySet().stream().flatMap(k -> ((ItemDataNode)k.getValue()).getAliases().stream().map(i -> Tuple.of((Object)i, k.getKey()))).collect(Collectors.toMap(Tuple::getFirst, Tuple::getSecond));
        }
        return this.aliasToItemIdCache;
    }

    private String getIdFromSnapshot(ItemStackSnapshot stackSnapshot) {
        Optional blockState = stackSnapshot.get(Keys.ITEM_BLOCKSTATE);
        return blockState.map(blockState1 -> blockState1.getId().toLowerCase()).orElseGet(() -> stackSnapshot.getType().getId());
    }

    private void clearCache() {
        this.aliasToItemIdCache = null;
        this.buyCache = null;
        this.sellCache = null;
        this.onItemUpdate.forEach(Action::action);
    }
}

