/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.dataservices.loaders;

import com.google.common.base.Preconditions;
import io.github.nucleuspowered.nucleus.dataservices.dataproviders.DataProvider;
import io.github.nucleuspowered.nucleus.dataservices.loaders.DataManager;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularWorldService;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import ninja.leaping.configurate.ConfigurationNode;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

public class WorldDataManager
extends DataManager<UUID, ConfigurationNode, ModularWorldService> {
    public WorldDataManager(BiFunction<UUID, Boolean, DataProvider<ConfigurationNode>> dataProviderFactory, Predicate<UUID> fileExist) {
        super(dataProviderFactory, fileExist);
    }

    @Override
    protected boolean shouldNotExpire(UUID key) {
        return Sponge.getServer().getWorld(key).isPresent();
    }

    @Override
    public Optional<ModularWorldService> getNew(UUID data, DataProvider<ConfigurationNode> dataProvider) throws Exception {
        ModularWorldService m = new ModularWorldService(dataProvider, ((WorldProperties)Sponge.getServer().getWorldProperties(data).orElseThrow(() -> new IllegalStateException("world"))).getUniqueId());
        m.loadInternal();
        return Optional.of(m);
    }

    public Optional<ModularWorldService> getWorld(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid);
        return this.get(uuid);
    }

    public Optional<ModularWorldService> getWorld(World world) {
        Preconditions.checkNotNull((Object)world);
        return this.getWorld(world.getUniqueId());
    }
}

