/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.NucleusPlugin;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;

public abstract class PreloadTasks {
    private PreloadTasks() {
    }

    public static List<Consumer<NucleusPlugin>> getPreloadTasks() {
        return Lists.newArrayList((Object[])new Consumer[]{plugin -> {
            try {
                Path main = plugin.getConfigDirPath().resolve("main.conf");
                if (!Files.exists(main, new LinkOption[0])) {
                    return;
                }
                HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(main)).build();
                CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
                if (node.getNode(new Object[]{"invulnerability", "require-invulnerbility-permission-on-login"}).isVirtual()) {
                    CommentedConfigurationNode cn = node.getNode(new Object[]{"misc", "require-god-permission-on-login"});
                    if (!cn.isVirtual()) {
                        boolean c = node.getNode(new Object[]{"misc", "require-god-permission-on-login"}).getBoolean();
                        node.getNode(new Object[]{"invulnerability", "require-invulnerbility-permission-on-login"}).setValue((Object)c);
                        node.getNode(new Object[]{"misc", "require-god-permission-on-login"}).setValue(null);
                    }
                    loader.save((ConfigurationNode)node);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }});
    }

    public static List<Consumer<NucleusPlugin>> getPreloadTasks2() {
        return Lists.newArrayList();
    }
}

