/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.command;

import com.google.common.collect.Sets;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.internal.annotations.SkipOnError;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.commented.SimpleCommentedConfigurationNode;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandMapping;
import org.spongepowered.api.plugin.PluginContainer;

public class CommandBuilder {
    private final Nucleus plugin;
    private final Set<Class<? extends AbstractCommand<?>>> commandSet;
    private final SimpleCommentedConfigurationNode sn;
    private final String moduleID;
    private final String moduleName;
    private static final Set<Class<? extends AbstractCommand>> registeredCommands = Sets.newHashSet();

    public static boolean isCommandRegistered(Class<? extends AbstractCommand> command) {
        return registeredCommands.contains(command);
    }

    public CommandBuilder(Nucleus plugin, Set<Class<? extends AbstractCommand<?>>> commandSet, String moduleID, String moduleName) {
        this.plugin = plugin;
        this.commandSet = commandSet;
        this.sn = SimpleCommentedConfigurationNode.root();
        this.moduleID = moduleID;
        this.moduleName = moduleName;
    }

    public <T extends AbstractCommand<?>> Optional<T> buildCommand(Class<T> commandClass) {
        return this.buildCommand(commandClass, true);
    }

    <T extends AbstractCommand<?>> Optional<T> buildCommand(Class<T> commandClass, boolean rootCmd) {
        Optional<T> optionalCommand = this.getInstance(commandClass);
        if (!optionalCommand.isPresent()) {
            return Optional.empty();
        }
        AbstractCommand c = (AbstractCommand)optionalCommand.get();
        try {
            c.setModuleName(this.moduleID, this.moduleName);
            c.setModuleCommands(this.commandSet);
            c.setCommandBuilder(this);
            c.postInit();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
        this.plugin.getDocGenCache().ifPresent(x -> x.addCommand(this.moduleID, c));
        String commandSection = c.getConfigSection();
        this.sn.getNode(new Object[]{commandSection}).setValue((Object)c.getDefaults());
        if (this.plugin.getCommandsConfig().getCommandNode(commandSection).getNode(new Object[]{"enabled"}).getBoolean(true)) {
            CommentedConfigurationNode cn = this.plugin.getCommandsConfig().getCommandNode(commandSection);
            ConfigurationNode node = cn.getNode(new Object[]{"aliases"});
            if (node.getValue() == null) {
                cn.removeChild((Object)"aliases");
            }
            try {
                if (rootCmd) {
                    String string = c.getAliases()[0];
                    String[] aliases = (String[])Arrays.stream(c.getAliases()).filter(x -> x.equals(string) || node.getNode(new Object[]{x}).getBoolean(true)).toArray(String[]::new);
                    this.checkMapping(Sponge.getCommandManager().register((Object)this.plugin, (CommandCallable)c, aliases).orElse(null), aliases);
                }
                for (String st : c.getRootCommandAliases()) {
                    if (!cn.getNode(new Object[]{"aliases", st}).getBoolean(true)) continue;
                    this.checkMapping(Sponge.getCommandManager().register((Object)this.plugin, (CommandCallable)c, new String[]{st}).orElse(null), new String[]{st});
                }
                if (c instanceof Reloadable) {
                    this.plugin.registerReloadable((Reloadable)((Object)c));
                }
            }
            catch (Exception exception) {
                throw new IllegalStateException(this.plugin.getMessageProvider().getMessageWithFormat("startup.commandfailiure", c.getAliases()[0], commandClass.getName()));
            }
            registeredCommands.add(c.getClass());
            return Optional.of(c);
        }
        return Optional.empty();
    }

    private <T extends AbstractCommand<?>> Optional<T> getInstance(Class<T> clazz) {
        try {
            AbstractCommand instance = (AbstractCommand)clazz.newInstance();
            if (instance.canLoad()) {
                return Optional.of(instance);
            }
            return Optional.empty();
        }
        catch (IllegalAccessException | InstantiationException | NoClassDefFoundError | RuntimeException e) {
            if (clazz.isAnnotationPresent(SkipOnError.class)) {
                this.plugin.getLogger().warn(NucleusPlugin.getNucleus().getMessageProvider().getMessageWithFormat("startup.injectablenotloaded", clazz.getName()));
                return Optional.empty();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public CommentedConfigurationNode getNodeToMerge() {
        return this.sn;
    }

    private void checkMapping(@Nullable CommandMapping commandMapping, String[] aliases) {
        if (commandMapping != null) {
            for (String a : aliases) {
                Optional<PluginContainer> opc = Sponge.getCommandManager().get(aliases[0]).map(x -> Sponge.getCommandManager().getOwner(x).orElse(null));
                if (opc.isPresent() && !opc.get().getId().equalsIgnoreCase("nucleus")) {
                    Nucleus.getNucleus().addStartupMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("startup.command.plugin", a, opc.get().getName(), "nucleus", aliases[0]));
                    continue;
                }
                if (opc.isPresent()) continue;
                Nucleus.getNucleus().addStartupMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("startup.command.fallback", a, "nucleus", aliases[0]));
            }
        } else {
            Optional<PluginContainer> ocm = Sponge.getCommandManager().get(aliases[0]).map(x -> Sponge.getCommandManager().getOwner(x).orElse(null));
            if (ocm.isPresent()) {
                Nucleus.getNucleus().addStartupMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("startup.command.noregisterplugin", aliases[0], ocm.get().getName()));
            } else {
                Nucleus.getNucleus().addStartupMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("startup.command.couldnotregister", aliases[0]));
            }
        }
    }
}

