/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.permissions;

import com.google.common.base.Preconditions;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.services.PermissionResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.inject.Singleton;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.Tristate;

@Singleton
public class PermissionResolverImpl
implements PermissionResolver {
    public static final PermissionResolverImpl INSTANCE = new PermissionResolverImpl();
    private final Map<String, String> permissions = new HashMap<String, String>();
    private final Map<Predicate<String>, String> permissionPredicates = new HashMap<Predicate<String>, String>();
    private boolean init = false;

    private PermissionResolverImpl() {
    }

    public void registerPermissions() {
        Preconditions.checkState((!this.init ? 1 : 0) != 0);
        this.init = true;
        PermissionService ps = Sponge.getServiceManager().provide(PermissionService.class).orElse(null);
        boolean isPresent = ps != null;
        for (Map.Entry<String, PermissionInformation> entry : Nucleus.getNucleus().getPermissionRegistry().getPermissions().entrySet()) {
            PermissionInformation info = entry.getValue();
            SuggestedLevel level = info.level;
            this.registerPermission(entry.getKey(), level);
            if (!isPresent || level.getRole() == null || !info.isNormal) continue;
            ps.newDescriptionBuilder((Object)Nucleus.getNucleus()).assign(level.getRole(), true).description(info.description).id(entry.getKey()).register();
        }
    }

    public void registerPermission(String perm, SuggestedLevel level) {
        if (this.permissions.containsKey(perm)) {
            return;
        }
        String l = level.getPermission();
        if (l != null) {
            this.permissions.put(perm, l);
        }
    }

    public void registerPermissionPredicate(Predicate<String> perm, SuggestedLevel level) {
        String l = level.getPermission();
        if (l != null) {
            this.permissionPredicates.put(perm, l);
        }
    }

    @Override
    public boolean hasPermission(Subject subject, String permission) {
        Tristate tristate = subject.getPermissionValue(subject.getActiveContexts(), permission);
        if (tristate == Tristate.UNDEFINED) {
            String result = this.permissions.get(permission);
            if (result != null) {
                return subject.hasPermission(result);
            }
            for (Map.Entry<Predicate<String>, String> entry : this.permissionPredicates.entrySet()) {
                if (!entry.getKey().test(permission)) continue;
                return subject.hasPermission(entry.getValue());
            }
            return subject.hasPermission(permission);
        }
        return tristate.asBoolean();
    }
}

