/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.qsml.event;

import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.api.events.NucleusModuleEvent;
import io.github.nucleuspowered.nucleus.api.exceptions.ModulesLoadedException;
import io.github.nucleuspowered.nucleus.api.exceptions.NoModuleException;
import io.github.nucleuspowered.nucleus.api.exceptions.UnremovableModuleException;
import io.github.nucleuspowered.nucleus.api.service.NucleusModuleService;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.enums.LoadingStatus;
import java.util.Map;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.impl.AbstractEvent;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public abstract class BaseModuleEvent
extends AbstractEvent
implements NucleusModuleEvent {
    private final NucleusPlugin plugin;
    private final Cause cause = Sponge.getCauseStackManager().getCurrentCause();
    private final Map<String, NucleusModuleEvent.ModuleEnableState> state;

    private BaseModuleEvent(NucleusPlugin plugin) {
        this.plugin = plugin;
        this.state = this.getState();
    }

    @Override
    public Map<String, NucleusModuleEvent.ModuleEnableState> getModuleList() {
        return this.state;
    }

    public Cause getCause() {
        return this.cause;
    }

    Map<String, NucleusModuleEvent.ModuleEnableState> getState() {
        return this.plugin.getModuleContainer().getModulesWithLoadingState().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> this.getFromLoadingStatus((LoadingStatus)((Object)((Object)v.getValue())))));
    }

    private NucleusModuleEvent.ModuleEnableState getFromLoadingStatus(LoadingStatus status) {
        if (status == LoadingStatus.DISABLED) {
            return NucleusModuleEvent.ModuleEnableState.DISABLED;
        }
        if (status == LoadingStatus.ENABLED) {
            return NucleusModuleEvent.ModuleEnableState.ENABLED;
        }
        return NucleusModuleEvent.ModuleEnableState.FORCE_ENABLED;
    }

    public static class Enabled
    extends BaseModuleEvent
    implements NucleusModuleEvent.Enabled {
        public Enabled(NucleusPlugin plugin) {
            super(plugin);
        }
    }

    public static class PreEnable
    extends BaseModuleEvent
    implements NucleusModuleEvent.PreEnable {
        public PreEnable(NucleusPlugin plugin) {
            super(plugin);
        }
    }

    public static class Complete
    extends BaseModuleEvent
    implements NucleusModuleEvent.Complete {
        public Complete(NucleusPlugin plugin) {
            super(plugin);
        }
    }

    public static class AboutToEnable
    extends BaseModuleEvent
    implements NucleusModuleEvent.AboutToEnable {
        public AboutToEnable(NucleusPlugin plugin) {
            super(plugin);
        }
    }

    public static class AboutToConstructEvent
    extends BaseModuleEvent
    implements NucleusModuleEvent.AboutToConstruct {
        public AboutToConstructEvent(NucleusPlugin plugin) {
            super(plugin);
        }

        @Override
        public Map<String, NucleusModuleEvent.ModuleEnableState> getModuleList() {
            return this.getState();
        }

        @Override
        public void disableModule(String module, Object plugin) throws UnremovableModuleException, NoModuleException {
            try {
                ((NucleusModuleService)Sponge.getServiceManager().provideUnchecked(NucleusModuleService.class)).removeModule(module, plugin);
            }
            catch (ModulesLoadedException e) {
                e.printStackTrace();
            }
        }
    }
}

