/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.logging;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.logging.DateRotatableFileLogger;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.spongepowered.api.GameState;
import org.spongepowered.api.Sponge;

public abstract class AbstractLoggingHandler {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
    protected DateRotatableFileLogger logger;
    private final List<String> queueEntry = Lists.newArrayList();
    private final String directoryName;
    private final String filePrefix;
    private final Object locking = new Object();
    private final Nucleus plugin = Nucleus.getNucleus();

    @Inject
    public AbstractLoggingHandler(String directoryName, String filePrefix) {
        this.directoryName = directoryName;
        this.filePrefix = filePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEntry(String s) {
        if (this.logger != null) {
            Object object = this.locking;
            synchronized (object) {
                this.queueEntry.add(s);
            }
        }
    }

    public abstract void onReload() throws Exception;

    public void onServerShutdown() throws IOException {
        Preconditions.checkState((boolean)Sponge.getGame().getState().equals((Object)GameState.SERVER_STOPPED));
        this.onShutdown();
    }

    protected void onShutdown() throws IOException {
        if (this.logger != null) {
            this.logger.close();
            this.logger = null;
        }
    }

    protected abstract boolean enabledLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTick() {
        block12: {
            ArrayList l;
            if (this.queueEntry.isEmpty()) {
                return;
            }
            Object object = this.locking;
            synchronized (object) {
                l = Lists.newArrayList(this.queueEntry);
                this.queueEntry.clear();
            }
            if (this.logger == null) {
                if (this.enabledLog()) {
                    try {
                        this.createLogger();
                    }
                    catch (IOException e) {
                        this.plugin.getLogger().warn(NucleusPlugin.getNucleus().getMessageProvider().getMessageWithFormat("commandlog.couldnotwrite", new String[0]));
                        if (this.plugin.isDebugMode()) {
                            e.printStackTrace();
                        }
                        return;
                    }
                } else {
                    return;
                }
            }
            try {
                this.writeEntry(l);
            }
            catch (IOException e) {
                this.plugin.getLogger().warn(NucleusPlugin.getNucleus().getMessageProvider().getMessageWithFormat("commandlog.couldnotwrite", new String[0]));
                if (!this.plugin.isDebugMode()) break block12;
                e.printStackTrace();
            }
        }
    }

    protected void createLogger() throws IOException {
        this.logger = new DateRotatableFileLogger(this.directoryName, this.filePrefix, s -> "[" + formatter.format(Instant.now().atZone(ZoneOffset.systemDefault())) + "] " + s);
    }

    private void writeEntry(Iterable<String> entry) throws IOException {
        if (this.logger != null) {
            this.logger.logEntry(entry);
        }
    }
}

