/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.ban.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import java.time.Instant;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.ban.Ban;

@RegisterCommand(value={"checkban"})
@Permissions(suggestedLevel=SuggestedLevel.MOD)
@NoModifiers
@RunAsync
@NonnullByDefault
public class CheckBanCommand
extends AbstractCommand<CommandSource> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.firstParsing((CommandElement[])new CommandElement[]{NucleusParameters.ONE_GAME_PROFILE_UUID, NucleusParameters.ONE_GAME_PROFILE})};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        GameProfile gp = args.hasAny("user uuid") ? (GameProfile)args.getOne("user uuid").get() : (GameProfile)args.getOne("user").get();
        BanService service = (BanService)Sponge.getServiceManager().provideUnchecked(BanService.class);
        Optional obp = service.getBanFor(gp);
        if (!obp.isPresent()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checkban.notset", gp.getName().orElse(Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.unknown", new String[0]))));
            return CommandResult.success();
        }
        Ban.Profile bp = (Ban.Profile)obp.get();
        String name = bp.getBanSource().isPresent() ? ((Text)bp.getBanSource().get()).toPlain() : Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.unknown", new String[0]);
        if (bp.getExpirationDate().isPresent()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checkban.bannedfor", gp.getName().orElse(Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.unknown", new String[0])), name, Util.getTimeToNow((Instant)bp.getExpirationDate().get())));
        } else {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checkban.bannedperm", gp.getName().orElse(Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.unknown", new String[0])), name));
        }
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checkban.created", Util.FULL_TIME_FORMATTER.withLocale(src.getLocale()).format(bp.getCreationDate())));
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("standard.reasoncoloured", TextSerializers.FORMATTING_CODE.serialize(bp.getReason().orElse(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("ban.defaultreason", new String[0])))));
        return CommandResult.success();
    }
}

