/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.ban.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.util.PermissionMessageChannel;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.ban.Ban;

@RegisterCommand(value={"unban", "pardon"})
@Permissions(suggestedLevel=SuggestedLevel.MOD)
@NoModifiers
@EssentialsEquivalent(value={"unban", "pardon"})
@NonnullByDefault
public class UnbanCommand
extends AbstractCommand<CommandSource> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.firstParsing((CommandElement[])new CommandElement[]{NucleusParameters.ONE_GAME_PROFILE_UUID, NucleusParameters.ONE_GAME_PROFILE})};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        GameProfile gp = args.hasAny("user uuid") ? (GameProfile)args.getOne("user uuid").get() : (GameProfile)args.getOne("user").get();
        BanService service = (BanService)Sponge.getServiceManager().provideUnchecked(BanService.class);
        Optional obp = service.getBanFor(gp);
        if (!obp.isPresent()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checkban.notset", gp.getName().orElse(Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.unknown", new String[0]))));
            return CommandResult.empty();
        }
        service.removeBan((Ban)obp.get());
        MutableMessageChannel notify = new PermissionMessageChannel("nucleus.ban.notify").asMutable();
        notify.addMember((MessageReceiver)src);
        notify.send(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.unban.success", ((Ban.Profile)obp.get()).getProfile().getName().orElse("standard.unknown"), src.getName()));
        return CommandResult.success();
    }
}

