/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.commands;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoHelpSubcommand;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandMapping;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.ChildCommandElementExecutor;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;

@NoModifiers
@Permissions
@NoHelpSubcommand
@RegisterCommand(value={"commandinfo"})
public class CommandInfoCommand
extends AbstractCommand<CommandSource> {
    private final String commandKey = "command";

    @Override
    protected CommandElement[] getArguments() {
        return new CommandElement[]{new CommandChoicesArgument()};
    }

    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        CommandMapping mapping = (CommandMapping)args.getOne(this.commandKey).get();
        MessageProvider provider = Nucleus.getNucleus().getMessageProvider();
        Text header = provider.getTextMessageWithFormat("command.commandinfo.title", mapping.getPrimaryAlias());
        ArrayList content = Lists.newArrayList();
        content.add(provider.getTextMessageWithFormat("command.commandinfo.owner", Sponge.getCommandManager().getOwner(mapping).map(x -> x.getName() + " (" + x.getId() + ")").orElseGet(() -> provider.getMessageWithFormat("standard.unknown", new String[0]))));
        content.add(provider.getTextMessageWithFormat("command.commandinfo.aliases", String.join((CharSequence)", ", mapping.getAllAliases())));
        if (mapping.getCallable() instanceof AbstractCommand) {
            this.nucleusCommand(content, src, provider, (AbstractCommand)mapping.getCallable());
        } else if (mapping.getCallable() instanceof CommandSpec) {
            this.specCommand(content, src, provider, mapping.getPrimaryAlias(), (CommandSpec)mapping.getCallable());
        } else {
            this.lowCommand(content, src, provider, mapping.getPrimaryAlias(), mapping.getCallable());
        }
        Util.getPaginationBuilder(src).title(header).contents((Iterable)content).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }

    private void nucleusCommand(List<Text> content, CommandSource source, MessageProvider provider, AbstractCommand<? extends CommandSource> abstractCommand) {
        content.add(provider.getTextMessageWithFormat("command.commandinfo.type", provider.getMessageWithFormat("command.commandinfo.nucleus", new String[0])));
        content.add(Text.EMPTY);
        List<Text> text = abstractCommand.getUsageText(source);
        if (text.isEmpty()) {
            content.add(provider.getTextMessageWithFormat("command.commandinfo.noinfo", new String[0]));
        } else {
            content.addAll(abstractCommand.getUsageText(source));
        }
    }

    private void specCommand(List<Text> content, CommandSource source, MessageProvider provider, String alias, CommandSpec spec) {
        content.add(provider.getTextMessageWithFormat("command.commandinfo.type", provider.getMessageWithFormat("command.commandinfo.spec", new String[0])));
        CommandExecutor executor = spec.getExecutor();
        if (executor instanceof ChildCommandElementExecutor) {
            try {
                content.add(provider.getTextMessageWithFormat("command.commandinfo.haschildren", new String[0]));
                Field field = ChildCommandElementExecutor.class.getDeclaredField("fallbackExecutor");
                field.setAccessible(true);
                content.add(provider.getTextMessageWithFormat("command.commandinfo.execclass", field.get(executor).getClass().getName()));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                content.add(provider.getTextMessageWithFormat("command.commandinfo.execclass", provider.getMessageWithFormat("standard.unknown", new String[0])));
            }
        }
        content.add(Text.EMPTY);
        content.add(provider.getTextMessageWithFormat("command.commandinfo.description", new String[0]));
        spec.getShortDescription(source).ifPresent(x -> {
            content.add(provider.getTextMessageWithFormat("command.commandinfo.shortdescription", new String[0]));
            content.add((Text)x);
            content.add(Text.EMPTY);
        });
        spec.getExtendedDescription(source).ifPresent(x -> {
            content.add(provider.getTextMessageWithFormat("command.commandinfo.description", new String[0]));
            content.add((Text)x);
            content.add(Text.EMPTY);
        });
        content.add(provider.getTextMessageWithTextFormat("command.commandinfo.usage", new Text[0]));
        content.add(Text.of((Object[])new Object[]{"/", alias, " ", spec.getUsage(source)}));
    }

    private void lowCommand(List<Text> content, CommandSource source, MessageProvider provider, String alias, CommandCallable callable) {
        content.add(provider.getTextMessageWithFormat("command.commandinfo.type", provider.getMessageWithFormat("command.commandinfo.callable", new String[0])));
        content.add(Text.EMPTY);
        callable.getShortDescription(source).ifPresent(x -> {
            content.add(provider.getTextMessageWithFormat("command.commandinfo.shortdescription", new String[0]));
            content.add((Text)x);
            content.add(Text.EMPTY);
        });
        callable.getHelp(source).ifPresent(x -> {
            content.add(provider.getTextMessageWithFormat("command.commandinfo.description", new String[0]));
            content.add((Text)x);
            content.add(Text.EMPTY);
        });
        content.add(provider.getTextMessageWithTextFormat("command.commandinfo.usage", new Text[0]));
        content.add(Text.of((Object[])new Object[]{"/", alias, " ", callable.getUsage(source)}));
    }

    private class CommandChoicesArgument
    extends CommandElement {
        protected CommandChoicesArgument() {
            super((Text)Text.of((String)"command"));
        }

        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            String next = args.next();
            return Sponge.getCommandManager().get(next).orElseThrow(() -> args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.commandinfo.nocommand", next)));
        }

        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            try {
                String s = args.peek().toLowerCase();
                return Sponge.getCommandManager().getAliases().stream().filter(x -> x.toLowerCase().startsWith(s)).collect(Collectors.toList());
            }
            catch (ArgumentParseException e) {
                return Lists.newArrayList((Iterable)Sponge.getCommandManager().getAliases());
            }
        }
    }
}

