/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.messages.ConfigMessageProvider;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.core.commands.NucleusCommand;
import java.util.List;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@RunAsync
@NoModifiers
@Permissions(prefix="nucleus", suggestedLevel=SuggestedLevel.OWNER)
@RegisterCommand(value={"update-messages"}, subcommandOf=NucleusCommand.class)
@NonnullByDefault
public class MessagesUpdateCommand
extends AbstractCommand<CommandSource> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"y"}).buildWith(GenericArguments.none())};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        boolean reload = Nucleus.getNucleus().reloadMessages();
        if (!reload) {
            throw ReturnMessageException.fromKey("command.nucleus.messageupdate.couldnotload", new Object[0]);
        }
        MessageProvider messageProvider = Nucleus.getNucleus().getMessageProvider();
        if (!(messageProvider instanceof ConfigMessageProvider)) {
            throw new ReturnMessageException(messageProvider.getTextMessageWithFormat("command.nucleus.messageupdate.notfile", new String[0]));
        }
        ConfigMessageProvider cmp = (ConfigMessageProvider)messageProvider;
        List<String> keys = cmp.checkForMigration();
        src.sendMessage(messageProvider.getTextMessageWithFormat("command.nucleus.messageupdate.reloaded", new String[0]));
        if (keys.isEmpty()) {
            return CommandResult.success();
        }
        if (args.hasAny("y")) {
            cmp.reset(keys);
            src.sendMessage(messageProvider.getTextMessageWithFormat("command.nucleus.messageupdate.reset", new String[0]));
        } else {
            src.sendMessage(messageProvider.getTextMessageWithFormat("command.nucleus.messageupdate.sometoupdate", String.valueOf(keys.size())));
            keys.forEach(x -> src.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, x})));
            src.sendMessage(messageProvider.getTextMessageWithFormat("command.nucleus.messageupdate.confirm", "/nucleus update-messages -y").toBuilder().onClick((ClickAction)TextActions.runCommand((String)"/nucleus update-messages -y")).build());
        }
        return CommandResult.success();
    }
}

