/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.listeners;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.service.NucleusWarmupManagerService;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.modules.core.config.WarmupConfig;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.command.SendCommandEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.network.ClientConnectionEvent;

public class WarmupListener
implements Reloadable,
ListenerBase {
    private NucleusWarmupManagerService service = Nucleus.getNucleus().getWarmupManager();
    private WarmupConfig warmupConfig = Nucleus.getNucleus().getWarmupConfig();

    @Listener(order=Order.LAST)
    public void onPlayerMovement(MoveEntityEvent event, @Root Player player) {
        if (this.warmupConfig.isOnMove() && !event.getFromTransform().getLocation().equals((Object)event.getToTransform().getLocation())) {
            this.cancelWarmup(player);
        }
    }

    @Listener(order=Order.LAST)
    public void onPlayerCommand(SendCommandEvent event, @Root Player player) {
        if (this.warmupConfig.isOnCommand()) {
            this.cancelWarmup(player);
        }
    }

    @Listener(order=Order.LAST)
    public void onPlayerQuit(ClientConnectionEvent.Disconnect event) {
        this.cancelWarmup(event.getTargetEntity());
    }

    private void cancelWarmup(Player player) {
        this.service.cleanup();
        if (this.service.removeWarmup(player.getUniqueId()) && player.isOnline()) {
            player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("warmup.cancel", new String[0]));
        }
    }

    @Override
    public void onReload() {
        this.warmupConfig = Nucleus.getNucleus().getWarmupConfig();
    }
}

