/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.services;

import com.google.common.collect.ImmutableMap;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.service.NucleusWorldUUIDChangeService;
import io.github.nucleuspowered.nucleus.internal.annotations.APIService;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import io.github.nucleuspowered.nucleus.internal.traits.InternalServiceManagerTrait;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfigAdapter;
import io.github.nucleuspowered.nucleus.util.Tuples;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;

@APIService(value=NucleusWorldUUIDChangeService.class)
public class UUIDChangeService
implements Reloadable,
InternalServiceManagerTrait,
NucleusWorldUUIDChangeService,
ServiceBase {
    private Map<UUID, UUID> mapping = ImmutableMap.of();
    private boolean canLoad = false;

    @Override
    public Optional<UUID> getMappedUUID(UUID oldUUID) {
        return Optional.ofNullable(this.mapping.get(oldUUID));
    }

    @Override
    public void onReload() throws Exception {
        if (!this.canLoad || !Nucleus.getNucleus().isServer()) {
            return;
        }
        this.mapping = (Map)((CoreConfig)this.getServiceUnchecked(CoreConfigAdapter.class).getNodeOrDefault()).getUuidMigration().entrySet().stream().map(x -> {
            try {
                UUID u = UUID.fromString((String)x.getValue());
                return new Tuples.NullableTuple(x.getKey(), u);
            }
            catch (Exception e) {
                return new Tuples.NullableTuple(x.getKey(), Sponge.getServer().getWorldProperties((String)x.getValue()).map(y -> y.getUniqueId()).orElse(null));
            }
        }).filter(x -> x.getSecond().isPresent()).collect(ImmutableMap.toImmutableMap(x -> (UUID)x.getFirst().get(), x -> (UUID)x.getSecond().get()));
    }

    public void setStateAndReload() throws Exception {
        this.canLoad = true;
        this.onReload();
    }
}

