/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.fun.commands;

import com.flowpowered.math.imaginary.Quaterniond;
import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.OcelotType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.explosion.Explosion;

@Permissions(supportsOthers=true)
@RegisterCommand(value={"kittycannon", "kc"})
@NonnullByDefault
public class KittyCannonCommand
extends AbstractCommand<CommandSource> {
    private final Random random = new Random();
    private final List<OcelotType> ocelotTypes = Lists.newArrayList((Iterable)Sponge.getRegistry().getAllOf(OcelotType.class));

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        return new HashMap<String, PermissionInformation>(){
            {
                MessageProvider provider = Nucleus.getNucleus().getMessageProvider();
                this.put("damage", new PermissionInformation(provider.getMessageWithFormat("permission.kittycannon.damage", new String[0]), SuggestedLevel.ADMIN));
                this.put("break", new PermissionInformation(provider.getMessageWithFormat("permission.kittycannon.break", new String[0]), SuggestedLevel.ADMIN));
                this.put("fire", new PermissionInformation(provider.getMessageWithFormat("permission.kittycannon.fire", new String[0]), SuggestedLevel.ADMIN));
            }
        };
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().permissionFlag(this.permissions.getPermissionWithSuffix("damage"), new String[]{"d", "-damageentities"}).permissionFlag(this.permissions.getPermissionWithSuffix("break"), new String[]{"b", "-breakblocks"}).permissionFlag(this.permissions.getPermissionWithSuffix("fire"), new String[]{"f", "-fire"}).buildWith(GenericArguments.optional((CommandElement)this.requirePermissionArg(NucleusParameters.MANY_PLAYER, this.permissions.getOthers())))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        Collection playerList = args.getAll("player");
        if (playerList.isEmpty()) {
            if (src instanceof Player) {
                playerList = Lists.newArrayList((Object[])new Player[]{(Player)src});
            } else {
                throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.playeronly", new String[0]));
            }
        }
        playerList.forEach(x -> this.getACat(src, (Player)x, args.hasAny("d"), args.hasAny("b"), args.hasAny("f")));
        return CommandResult.success();
    }

    private void getACat(CommandSource source, Player spawnAt, boolean damageEntities, boolean breakBlocks, boolean causeFire) {
        Vector3d headRotation = spawnAt.getHeadRotation();
        Quaterniond rot = Quaterniond.fromAxesAnglesDeg((double)headRotation.getX(), (double)(-headRotation.getY()), (double)headRotation.getZ());
        Vector3d velocity = spawnAt.getVelocity().add(rot.rotate(Vector3d.UNIT_Z).mul(5.0 * this.random.nextDouble() + 1.0));
        World world = spawnAt.getWorld();
        Entity cat = world.createEntity(EntityTypes.OCELOT, spawnAt.getLocation().getPosition().add(0.0f, 1.0f, 0.0f).add(spawnAt.getTransform().getRotationAsQuaternion().getDirection()));
        cat.offer(Keys.OCELOT_TYPE, (Object)this.ocelotTypes.get(this.random.nextInt(this.ocelotTypes.size())));
        Sponge.getScheduler().createTaskBuilder().intervalTicks(5L).delayTicks(5L).execute((Consumer)new CatTimer(world.getUniqueId(), cat.getUniqueId(), spawnAt, this.random.nextInt(60) + 20, damageEntities, breakBlocks, causeFire)).submit((Object)Nucleus.getNucleus());
        CauseStackHelper.createFrameWithCausesWithConsumer(c -> world.spawnEntity(cat), source);
        cat.offer(Keys.VELOCITY, (Object)velocity);
    }

    private class CatTimer
    implements Consumer<Task> {
        private final UUID entity;
        private final UUID world;
        private final Player player;
        private final boolean damageEntities;
        private final boolean causeFire;
        private final boolean breakBlocks;
        private int ticksToDestruction;

        private CatTimer(UUID world, UUID entity, Player player, int ticksToDestruction, boolean damageEntities, boolean breakBlocks, boolean causeFire) {
            this.entity = entity;
            this.ticksToDestruction = ticksToDestruction;
            this.world = world;
            this.player = player;
            this.damageEntities = damageEntities;
            this.breakBlocks = breakBlocks;
            this.causeFire = causeFire;
        }

        @Override
        public void accept(Task task) {
            Optional oWorld = Sponge.getServer().getWorld(this.world);
            if (!oWorld.isPresent()) {
                task.cancel();
                return;
            }
            Optional oe = ((World)oWorld.get()).getEntity(this.entity);
            if (!oe.isPresent()) {
                task.cancel();
                return;
            }
            Entity e = (Entity)oe.get();
            if (e.isRemoved()) {
                task.cancel();
                return;
            }
            this.ticksToDestruction -= 5;
            if (this.ticksToDestruction <= 0 || e.isOnGround()) {
                Explosion explosion = Explosion.builder().location(e.getLocation()).canCauseFire(this.causeFire).shouldDamageEntities(this.damageEntities).shouldPlaySmoke(true).shouldBreakBlocks(this.breakBlocks).radius(2.0f).build();
                e.remove();
                CauseStackHelper.createFrameWithCausesWithConsumer(c -> ((World)oWorld.get()).triggerExplosion(explosion), this.player);
                task.cancel();
            }
        }
    }
}

