/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.ignore.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.traits.MessageProviderTrait;
import io.github.nucleuspowered.nucleus.modules.ignore.datamodules.IgnoreUserDataModule;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NoModifiers
@RunAsync
@Permissions(suggestedLevel=SuggestedLevel.USER, supportsOthers=true)
@RegisterCommand(value={"ignorelist", "listignore", "ignored"})
@NonnullByDefault
public class IgnoreListCommand
extends AbstractCommand.SimpleTargetOtherUser
implements MessageProviderTrait {
    @Override
    protected CommandResult executeWithPlayer(CommandSource source, User target, CommandContext args, boolean isSelf) {
        List ignoredList = Nucleus.getNucleus().getUserDataManager().getUnchecked(target).get(IgnoreUserDataModule.class).getIgnoreList().stream().map(x -> Nucleus.getNucleus().getNameUtil().getName((UUID)x).orElseGet(() -> this.getMessage("command.ignorelist.unknown", new String[]{x.toString()}))).collect(Collectors.toList());
        if (ignoredList.isEmpty()) {
            if (isSelf) {
                source.sendMessage(this.getMessage("command.ignorelist.noignores.self"));
            } else {
                source.sendMessage(this.getMessage("command.ignorelist.noignores.other", new Object[]{target}));
            }
        } else {
            Util.getPaginationBuilder(source).contents(ignoredList).title(this.getMessage("command.ignorelist.header", new Object[]{target})).sendTo((MessageReceiver)source);
        }
        return CommandResult.success();
    }
}

