/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands.itemname;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.modules.item.commands.itemname.ItemNameCommand;
import java.util.Optional;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(prefix="itemname")
@RegisterCommand(value={"clear"}, subcommandOf=ItemNameCommand.class, rootAliasRegister={"clearitemname", "resetitemname"})
@NonnullByDefault
public class ItemNameClearCommand
extends AbstractCommand<Player> {
    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        MessageProvider provider = Nucleus.getNucleus().getMessageProvider();
        if (!src.getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
            throw ReturnMessageException.fromKey("command.itemname.clear.noitem", new Object[0]);
        }
        ItemStack stack = (ItemStack)src.getItemInHand(HandTypes.MAIN_HAND).get();
        Optional data = stack.get(Keys.DISPLAY_NAME);
        if (!data.isPresent()) {
            throw ReturnMessageException.fromKey("command.lore.clear.none", new Object[0]);
        }
        if (stack.remove(Keys.DISPLAY_NAME).isSuccessful()) {
            src.setItemInHand(HandTypes.MAIN_HAND, stack);
            src.sendMessage(provider.getTextMessageWithFormat("command.itemname.clear.success", new String[0]));
            return CommandResult.success();
        }
        throw ReturnMessageException.fromKey("command.itemname.clear.fail", new Object[0]);
    }
}

