/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jail;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.qsml.module.ConfigurableModule;
import io.github.nucleuspowered.nucleus.internal.text.Tokens;
import io.github.nucleuspowered.nucleus.modules.jail.commands.CheckJailCommand;
import io.github.nucleuspowered.nucleus.modules.jail.config.JailConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.jail.data.JailData;
import io.github.nucleuspowered.nucleus.modules.jail.services.JailHandler;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.annotations.ModuleData;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;

@ModuleData(id="jail", name="Jail")
public class JailModule
extends ConfigurableModule<JailConfigAdapter> {
    public static final String ID = "jail";

    @Override
    public JailConfigAdapter createAdapter() {
        return new JailConfigAdapter();
    }

    @Override
    public void performEnableTasks() {
        this.createSeenModule(CheckJailCommand.class, (CommandSource c, User u) -> {
            JailHandler jh = Nucleus.getNucleus().getInternalServiceManager().getService(JailHandler.class).get();
            if (jh.isPlayerJailed((User)u)) {
                JailData jd = jh.getPlayerJailDataInternal((User)u).get();
                Text.Builder m = jd.getRemainingTime().isPresent() ? this.getMessageFor(c.getLocale(), "seen.isjailed.temp", Util.getTimeStringFromSeconds(jd.getRemainingTime().get().getSeconds())).toBuilder() : this.getMessageFor(c.getLocale(), "seen.isjailed.perm").toBuilder();
                return Lists.newArrayList((Object[])new Text[]{m.onClick((ClickAction)TextActions.runCommand((String)("/nucleus:checkjail " + u.getName()))).onHover((HoverAction)TextActions.showText((Text)this.getMessageFor(c.getLocale(), "standard.clicktoseemore"))).build(), this.getMessageFor(c.getLocale(), "standard.reason", jd.getReason())});
            }
            return Lists.newArrayList((Object[])new Text[]{this.getMessageFor(c.getLocale(), "seen.notjailed")});
        });
    }

    @Override
    protected Map<String, Tokens.Translator> tokensToRegister() {
        return ImmutableMap.builder().put((Object)"jailed", (Object)new Tokens.TrueFalseVariableTranslator(){
            final Optional<Text> def = Optional.of(Text.of((Object[])new Object[]{TextColors.GRAY, "[Jailed]"}));

            @Override
            protected Optional<Text> getDefault() {
                return this.def;
            }

            @Override
            protected boolean condition(CommandSource commandSource) {
                return commandSource instanceof Player && JailModule.this.getServiceUnchecked(JailHandler.class).isPlayerJailed((User)((Player)commandSource));
            }
        }).put((Object)ID, (source, variableString, variables) -> {
            if (source instanceof Player) {
                return this.getServiceUnchecked(JailHandler.class).getPlayerJailData((User)((Player)source)).map(x -> Text.of((String)x.getJailName()));
            }
            return Optional.empty();
        }).build();
    }
}

