/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jail.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.modules.jail.commands.JailsCommand;
import io.github.nucleuspowered.nucleus.modules.jail.services.JailHandler;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Permissions(prefix="jail")
@RunAsync
@NoModifiers
@RegisterCommand(value={"set"}, subcommandOf=JailsCommand.class, rootAliasRegister={"setjail", "createjail"})
@EssentialsEquivalent(value={"setjail", "createjail"})
@NonnullByDefault
public class SetJailCommand
extends AbstractCommand<Player> {
    private final String jailName = "jail";
    private final JailHandler handler = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(JailHandler.class);

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.onlyOne((CommandElement)GenericArguments.string((Text)Text.of((String)this.jailName)))};
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) {
        String name = ((String)args.getOne(this.jailName).get()).toLowerCase();
        if (this.handler.getJail(name).isPresent()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.jails.set.exists", name));
            return CommandResult.empty();
        }
        if (this.handler.setJail(name, (Location<World>)src.getLocation(), src.getRotation())) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.jails.set.success", name));
            return CommandResult.success();
        }
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.jails.set.error", name));
        return CommandResult.empty();
    }
}

