/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jail.listeners;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.events.NucleusSendToSpawnEvent;
import io.github.nucleuspowered.nucleus.api.events.NucleusTeleportEvent;
import io.github.nucleuspowered.nucleus.api.nucleusdata.NamedLocation;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularUserService;
import io.github.nucleuspowered.nucleus.internal.CommandPermissionHandler;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.modules.core.events.NucleusOnLoginEvent;
import io.github.nucleuspowered.nucleus.modules.fly.datamodules.FlyUserDataModule;
import io.github.nucleuspowered.nucleus.modules.jail.commands.JailCommand;
import io.github.nucleuspowered.nucleus.modules.jail.config.JailConfig;
import io.github.nucleuspowered.nucleus.modules.jail.config.JailConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.jail.data.JailData;
import io.github.nucleuspowered.nucleus.modules.jail.datamodules.JailUserDataModule;
import io.github.nucleuspowered.nucleus.modules.jail.services.JailHandler;
import io.github.nucleuspowered.nucleus.util.PermissionMessageChannel;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.action.InteractEvent;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.command.SendCommandEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.RespawnPlayerEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class JailListener
implements Reloadable,
ListenerBase {
    private final JailHandler handler = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(JailHandler.class);
    private final String notify;
    private final String teleport;
    private final String teleportto;
    private List<String> allowedCommands;

    @Inject
    public JailListener() {
        CommandPermissionHandler cph = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(JailCommand.class);
        this.notify = cph.getPermissionWithSuffix("notify");
        this.teleport = cph.getPermissionWithSuffix("teleportjailed");
        this.teleportto = cph.getPermissionWithSuffix("teleporttojailed");
    }

    @Listener
    public void onPlayerLogin(NucleusOnLoginEvent event, @Getter(value="getTargetUser") User user, @Getter(value="getUserService") ModularUserService qs) {
        JailUserDataModule userDataModule = qs.get(JailUserDataModule.class);
        if (!userDataModule.getJailData().isPresent()) {
            return;
        }
        JailData jd = userDataModule.getJailData().get();
        Optional<NamedLocation> owl = this.handler.getWarpLocation(user);
        if (!owl.isPresent()) {
            new PermissionMessageChannel(this.notify).send(Text.of((Object[])new Object[]{TextColors.RED, "WARNING: No jail is defined. Jailed players are going free!"}));
            this.handler.unjailPlayer(user);
            return;
        }
        event.setTo(owl.get().getTransform().get());
        if (userDataModule.jailOnNextLogin()) {
            if (event.getFrom().equals(owl.get().getTransform().get())) {
                jd.setPreviousLocation((Location<World>)event.getFrom().getLocation());
            }
            userDataModule.setJailData(jd);
            qs.get(FlyUserDataModule.class).setFlying(false);
        }
    }

    @Listener(order=Order.LATE)
    public void onPlayerJoin(ClientConnectionEvent.Join event) {
        Player user = event.getTargetEntity();
        Optional<ModularUserService> oqs = Nucleus.getNucleus().getUserDataManager().get((User)user);
        if (!oqs.isPresent()) {
            return;
        }
        JailUserDataModule qs = oqs.get().get(JailUserDataModule.class);
        Optional<JailData> data = this.handler.getPlayerJailDataInternal((User)user);
        if (qs.jailOnNextLogin() && data.isPresent()) {
            NamedLocation owl = this.handler.getWarpLocation((User)user).get();
            JailData jd = data.get();
            Optional<Duration> timeLeft = jd.getRemainingTime();
            Text message = timeLeft.map(duration -> Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.jail.jailedfor", owl.getName(), Nucleus.getNucleus().getNameUtil().getNameFromUUID(jd.getJailerInternal()), Util.getTimeStringFromSeconds(duration.getSeconds()))).orElseGet(() -> Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.jail.jailedperm", owl.getName(), Nucleus.getNucleus().getNameUtil().getNameFromUUID(jd.getJailerInternal()), "", ""));
            user.sendMessage(message);
            user.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("standard.reasoncoloured", jd.getReason()));
        }
        qs.setJailOnNextLogin(false);
        Sponge.getScheduler().createTaskBuilder().async().delay(500L, TimeUnit.MILLISECONDS).execute(() -> {
            Optional<JailData> omd = qs.getJailData();
            if (omd.isPresent()) {
                JailData md = omd.get();
                md.nextLoginToTimestamp();
                if (md.expired()) {
                    this.handler.unjailPlayer((User)user);
                } else {
                    this.handler.onJail(md, event.getTargetEntity());
                }
            }
        }).submit((Object)Nucleus.getNucleus());
    }

    @Listener
    public void onRequestSent(NucleusTeleportEvent.Request event, @Root Player cause, @Getter(value="getTargetEntity") Player player) {
        if (this.handler.isPlayerJailed((User)cause)) {
            event.setCancelled(true);
            event.setCancelMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("jail.teleportcause.isjailed", new String[0]));
        } else if (this.handler.isPlayerJailed((User)player)) {
            event.setCancelled(true);
            event.setCancelMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("jail.teleporttarget.isjailed", player.getName()));
        }
    }

    @Listener
    public void onAboutToTeleport(NucleusTeleportEvent.AboutToTeleport event, @Root CommandSource cause, @Getter(value="getTargetEntity") Player player) {
        if (this.handler.isPlayerJailed((User)player)) {
            if (!this.hasPermission((Subject)cause, this.teleport)) {
                event.setCancelled(true);
                event.setCancelMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("jail.abouttoteleporttarget.isjailed", player.getName()));
            } else if (!this.hasPermission((Subject)cause, this.teleportto)) {
                event.setCancelled(true);
                event.setCancelMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("jail.abouttoteleportcause.targetisjailed", player.getName()));
            }
        }
    }

    @Listener
    public void onCommand(SendCommandEvent event, @Root Player player) {
        if (this.handler.checkJail((User)player, false) && this.allowedCommands.stream().noneMatch(x -> event.getCommand().equalsIgnoreCase((String)x))) {
            event.setCancelled(true);
            this.handler.checkJail((User)player, true);
        }
    }

    @Listener
    public void onBlockChange(ChangeBlockEvent event, @Root Player player) {
        event.setCancelled(this.handler.checkJail((User)player, true));
    }

    @Listener
    public void onInteract(InteractEvent event, @Root Player player) {
        event.setCancelled(this.handler.checkJail((User)player, true));
    }

    @Listener
    public void onSpawn(RespawnPlayerEvent event) {
        if (this.handler.checkJail((User)event.getTargetEntity(), false)) {
            event.setToTransform(event.getToTransform().setLocation(this.handler.getWarpLocation((User)event.getTargetEntity()).get().getLocation().get()));
        }
    }

    @Listener
    public void onSendToSpawn(NucleusSendToSpawnEvent event, @Getter(value="getTargetUser") User user) {
        if (this.handler.checkJail(user, false)) {
            event.setCancelled(true);
            event.setCancelReason(Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("jail.isjailed", new String[0]));
        }
    }

    @Override
    public void onReload() {
        this.allowedCommands = ((JailConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(JailConfigAdapter.class).getNodeOrDefault()).getAllowedCommands();
    }
}

