/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jail.services;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.exceptions.NoSuchLocationException;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Inmate;
import io.github.nucleuspowered.nucleus.api.nucleusdata.NamedLocation;
import io.github.nucleuspowered.nucleus.api.service.NucleusJailService;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularGeneralService;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularUserService;
import io.github.nucleuspowered.nucleus.internal.annotations.APIService;
import io.github.nucleuspowered.nucleus.internal.data.EndTimestamp;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.internal.teleport.NucleusTeleportHandler;
import io.github.nucleuspowered.nucleus.modules.core.datamodules.CoreUserDataModule;
import io.github.nucleuspowered.nucleus.modules.fly.datamodules.FlyUserDataModule;
import io.github.nucleuspowered.nucleus.modules.jail.data.JailData;
import io.github.nucleuspowered.nucleus.modules.jail.datamodules.JailGeneralDataModule;
import io.github.nucleuspowered.nucleus.modules.jail.datamodules.JailUserDataModule;
import io.github.nucleuspowered.nucleus.modules.jail.events.JailEvent;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.storage.WorldProperties;

@NonnullByDefault
@APIService(value=NucleusJailService.class)
public class JailHandler
implements NucleusJailService,
ContextCalculator<Subject>,
ServiceBase {
    private final ModularGeneralService store = Nucleus.getNucleus().getGeneralService();
    private final Map<UUID, Context> jailDataCache = Maps.newHashMap();
    private static final Context jailContext = new Context("nucleus_jailed", "true");

    private JailGeneralDataModule getModule() {
        return this.store.get(JailGeneralDataModule.class);
    }

    @Override
    public Optional<NamedLocation> getJail(String warpName) {
        return this.getModule().getJailLocation(warpName);
    }

    @Override
    public boolean removeJail(String warpName) {
        return this.getModule().removeJail(warpName);
    }

    @Override
    public boolean setJail(String warpName, Location<World> location, Vector3d rotation) {
        return this.getModule().addJail(warpName, location, rotation);
    }

    @Override
    public Map<String, NamedLocation> getJails() {
        return this.getModule().getJails();
    }

    public boolean isPlayerJailedCached(User user) {
        return this.jailDataCache.containsKey(user.getUniqueId());
    }

    @Override
    public boolean isPlayerJailed(User user) {
        return this.getPlayerJailDataInternal(user).isPresent();
    }

    @Override
    public Optional<Inmate> getPlayerJailData(User user) {
        return this.getPlayerJailDataInternal(user).map(x -> x);
    }

    public Optional<JailData> getPlayerJailDataInternal(User user) {
        try {
            Optional<JailData> data = Nucleus.getNucleus().getUserDataManager().get(user, false).map(y -> y.get(JailUserDataModule.class).getJailData().orElse(null));
            if (data.isPresent()) {
                this.jailDataCache.put(user.getUniqueId(), new Context("nucleus_jail", data.get().getJailName()));
            } else {
                this.jailDataCache.put(user.getUniqueId(), null);
            }
            return data;
        }
        catch (Exception e) {
            if (Nucleus.getNucleus().isDebugMode()) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    @Override
    public boolean jailPlayer(User victim, String jail, CommandSource jailer, String reason) throws NoSuchLocationException {
        Preconditions.checkNotNull((Object)victim);
        Preconditions.checkNotNull((Object)jail);
        Preconditions.checkNotNull((Object)jailer);
        Preconditions.checkNotNull((Object)reason);
        NamedLocation location = this.getJail(jail).orElseThrow(NoSuchLocationException::new);
        return this.jailPlayer(victim, new JailData(Util.getUUID(jailer), location.getName(), reason, (Location<World>)((Location)victim.getPlayer().map(Locatable::getLocation).orElse(null))));
    }

    public boolean jailPlayer(User user, JailData data) {
        ModularUserService modularUserService = Nucleus.getNucleus().getUserDataManager().getUnchecked(user);
        JailUserDataModule jailUserDataModule = modularUserService.get(JailUserDataModule.class);
        if (jailUserDataModule.getJailData().isPresent()) {
            return false;
        }
        Optional<NamedLocation> owl = this.getJail(data.getJailName());
        NamedLocation wl = owl.filter(x -> x.getLocation().isPresent()).orElseGet(() -> {
            if (!this.getJails().isEmpty()) {
                return null;
            }
            return (NamedLocation)((Map.Entry)this.getJails().entrySet().stream().findFirst().get()).getValue();
        });
        if (wl == null) {
            return false;
        }
        jailUserDataModule.setJailData(data);
        if (user.isOnline()) {
            Sponge.getScheduler().createSyncExecutor((Object)Nucleus.getNucleus()).execute(() -> {
                Player player = (Player)user.getPlayer().get();
                Nucleus.getNucleus().getTeleportHandler().teleportPlayer(player, ((NamedLocation)owl.get()).getLocation().get(), ((NamedLocation)owl.get()).getRotation(), NucleusTeleportHandler.StandardTeleportMode.NO_CHECK, Sponge.getCauseStackManager().getCurrentCause(), true);
                modularUserService.get(FlyUserDataModule.class).setFlying(false);
            });
        } else {
            jailUserDataModule.setJailOnNextLogin(true);
        }
        this.jailDataCache.put(user.getUniqueId(), new Context("nucleus_jail", data.getJailName()));
        Sponge.getEventManager().post((Event)new JailEvent.Jailed(user, CauseStackHelper.createCause(Util.getObjectFromUUID(data.getJailerInternal())), data.getJailName(), TextSerializers.FORMATTING_CODE.deserialize(data.getReason()), data.getRemainingTime().orElse(null)));
        return true;
    }

    @Override
    public boolean unjailPlayer(User user) {
        return this.unjailPlayer(user, Sponge.getCauseStackManager().getCurrentCause());
    }

    public boolean unjailPlayer(User user, Cause cause) {
        ModularUserService modularUserService = Nucleus.getNucleus().getUserDataManager().getUnchecked(user);
        JailUserDataModule jailUserDataModule = modularUserService.get(JailUserDataModule.class);
        Optional<JailData> ojd = jailUserDataModule.getJailData();
        if (!ojd.isPresent()) {
            return false;
        }
        Optional<Location<World>> ow = ojd.get().getPreviousLocation();
        this.jailDataCache.put(user.getUniqueId(), null);
        if (user.isOnline()) {
            Player player = (Player)user.getPlayer().get();
            Sponge.getScheduler().createSyncExecutor((Object)Nucleus.getNucleus()).execute(() -> {
                NucleusTeleportHandler.setLocation(player, (Location<World>)ow.orElseGet(() -> player.getWorld().getSpawnLocation()));
                player.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("jail.elapsed", new String[0]));
                jailUserDataModule.removeJailData();
            });
        } else {
            modularUserService.get(CoreUserDataModule.class).sendToLocationOnLogin((Location<World>)ow.orElseGet(() -> new Location((Extent)Sponge.getServer().getWorld(((WorldProperties)Sponge.getServer().getDefaultWorld().get()).getUniqueId()).get(), ((WorldProperties)Sponge.getServer().getDefaultWorld().get()).getSpawnPosition())));
            jailUserDataModule.removeJailData();
        }
        Sponge.getEventManager().post((Event)new JailEvent.Unjailed(user, cause));
        return true;
    }

    public Optional<NamedLocation> getWarpLocation(User user) {
        if (!this.isPlayerJailed(user)) {
            return Optional.empty();
        }
        Optional<NamedLocation> owl = this.getJail(this.getPlayerJailDataInternal(user).get().getJailName());
        if (!owl.isPresent()) {
            Collection<NamedLocation> wl = this.getJails().values();
            if (wl.isEmpty()) {
                return Optional.empty();
            }
            owl = wl.stream().findFirst();
        }
        return owl;
    }

    public void accumulateContexts(Subject calculable, Set<Context> accumulator) {
        if (calculable instanceof User) {
            Context co;
            UUID c = ((User)calculable).getUniqueId();
            if (!this.jailDataCache.containsKey(c)) {
                this.getPlayerJailDataInternal((User)calculable);
            }
            if ((co = this.jailDataCache.get(c)) != null) {
                accumulator.add(co);
                accumulator.add(jailContext);
            }
        }
    }

    public boolean matches(Context context, Subject subject) {
        if (context.getKey().equals("nucleus_jail")) {
            if (subject instanceof User) {
                UUID u = ((User)subject).getUniqueId();
                return context.equals((Object)this.jailDataCache.get(u));
            }
        } else if (context.getKey().equals("nucleus_jailed") && subject instanceof User) {
            UUID u = ((User)subject).getUniqueId();
            return this.jailDataCache.get(u) != null;
        }
        return false;
    }

    public boolean checkJail(User player, boolean sendMessage) {
        if (!this.getPlayerJailDataInternal(player).map(EndTimestamp::expired).orElse(true).booleanValue()) {
            if (sendMessage) {
                Nucleus.getNucleus().getUserDataManager().getUnchecked(player).get(FlyUserDataModule.class).setFlying(false);
                player.getPlayer().ifPresent(this::onJail);
            }
            return true;
        }
        return false;
    }

    private void onJail(Player user) {
        this.getPlayerJailDataInternal((User)user).ifPresent(x -> this.onJail((JailData)x, user));
    }

    public void onJail(JailData md, Player user) {
        MessageProvider provider = Nucleus.getNucleus().getMessageProvider();
        if (md.getEndTimestamp().isPresent()) {
            user.sendMessage(provider.getTextMessageWithFormat("jail.playernotify.time", Util.getTimeStringFromSeconds(Instant.now().until(md.getEndTimestamp().get(), ChronoUnit.SECONDS))));
        } else {
            user.sendMessage(provider.getTextMessageWithFormat("jail.playernotify.standard", new String[0]));
        }
        user.sendMessage(provider.getTextMessageWithFormat("standard.reasoncoloured", md.getReason()));
    }
}

