/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jump.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.teleport.NucleusTeleportHandler;
import io.github.nucleuspowered.nucleus.modules.jump.config.JumpConfig;
import io.github.nucleuspowered.nucleus.modules.jump.config.JumpConfigAdapter;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.util.blockray.BlockRayHit;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Permissions
@RegisterCommand(value={"thru", "through"})
@NonnullByDefault
public class ThruCommand
extends AbstractCommand<Player>
implements Reloadable {
    private int maxThru = 20;

    @Override
    public CommandResult executeCommand(Player player, CommandContext args, Cause cause) {
        BlockRay playerBlockRay = BlockRay.from((Entity)player).distanceLimit((double)this.maxThru).build();
        World world = player.getWorld();
        while (playerBlockRay.hasNext() && world.getBlockType(playerBlockRay.next().getBlockPosition()).equals(BlockTypes.AIR)) {
        }
        if (!playerBlockRay.hasNext()) {
            player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.thru.nowall", new String[0]));
            return CommandResult.empty();
        }
        do {
            BlockRayHit b = playerBlockRay.next();
            if (!player.getWorld().getBlockType(b.getBlockPosition()).equals(BlockTypes.AIR)) continue;
            if (!Util.isLocationInWorldBorder((Location<World>)b.getLocation())) {
                player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.jump.outsideborder", new String[0]));
                return CommandResult.empty();
            }
            if (Nucleus.getNucleus().getTeleportHandler().teleportPlayer(player, (Location<World>)b.getLocation(), (NucleusTeleportHandler.TeleportMode)NucleusTeleportHandler.StandardTeleportMode.SAFE_TELEPORT).isSuccess()) {
                player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.thru.success", new String[0]));
                return CommandResult.success();
            }
            player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.thru.notsafe", new String[0]));
            return CommandResult.empty();
        } while (playerBlockRay.hasNext());
        player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.thru.nospot", new String[0]));
        return CommandResult.empty();
    }

    @Override
    public void onReload() {
        this.maxThru = ((JumpConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(JumpConfigAdapter.class).getNodeOrDefault()).getMaxThru();
    }
}

