/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.commands.kit;

import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.exceptions.KitRedeemException;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Kit;
import io.github.nucleuspowered.nucleus.api.service.NucleusKitService;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.kit.commands.KitFallbackBase;
import io.github.nucleuspowered.nucleus.modules.kit.commands.kit.KitCommand;
import io.github.nucleuspowered.nucleus.modules.kit.config.KitConfig;
import io.github.nucleuspowered.nucleus.modules.kit.config.KitConfigAdapter;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Permissions(prefix="kit")
@RegisterCommand(value={"give"}, subcommandOf=KitCommand.class)
@NonnullByDefault
public class KitGiveCommand
extends KitFallbackBase<CommandSource>
implements Reloadable {
    private boolean mustGetAll;
    private boolean isDrop;

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap mspi = Maps.newHashMap();
        mspi.put("overridecheck", PermissionInformation.getWithTranslation("permission.kit.give.override", SuggestedLevel.ADMIN));
        return mspi;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().permissionFlag(this.permissions.getPermissionWithSuffix("overridecheck"), new String[]{"i", "-ignore"}).buildWith(GenericArguments.seq((CommandElement[])new CommandElement[]{NucleusParameters.ONE_PLAYER, KitFallbackBase.KIT_PARAMETER_NO_PERM_CHECK}))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        Kit kit = (Kit)args.getOne("kit").get();
        Player player = (Player)args.getOne("player").get();
        boolean skip = args.hasAny("i");
        if (src instanceof Player && player.getUniqueId().equals(((Player)src).getUniqueId())) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kit.give.self", new String[0]));
        }
        Text playerName = Nucleus.getNucleus().getNameUtil().getName((User)player);
        LiteralText kitName = Text.of((String)kit.getName());
        try {
            NucleusKitService.RedeemResult redeemResult = KIT_HANDLER.redeemKit(kit, player, !skip, this.mustGetAll);
            if (!redeemResult.rejected().isEmpty()) {
                if (this.isDrop) {
                    player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.kit.give.itemsdropped", playerName));
                    redeemResult.rejected().forEach(x -> Util.dropItemOnFloorAtLocation(x, (Location<World>)player.getLocation()));
                } else {
                    player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.kit.give.fullinventory", playerName));
                }
            }
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.kit.give.spawned", new Text[]{playerName, kitName}));
            if (kit.isDisplayMessageOnRedeem()) {
                player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kit.spawned", kit.getName()));
            }
            return CommandResult.success();
        }
        catch (KitRedeemException ex) {
            switch (ex.getReason()) {
                case ALREADY_REDEEMED: {
                    throw ReturnMessageException.fromKey("command.kit.give.onetime.alreadyredeemed", kitName, playerName);
                }
                case COOLDOWN_NOT_EXPIRED: {
                    KitRedeemException.Cooldown kre = (KitRedeemException.Cooldown)ex;
                    throw ReturnMessageException.fromKey("command.kit.give.cooldown", playerName, Text.of((String)Util.getTimeStringFromSeconds(kre.getTimeLeft().getSeconds())), kitName);
                }
                case PRE_EVENT_CANCELLED: {
                    KitRedeemException.PreCancelled krepe = (KitRedeemException.PreCancelled)ex;
                    throw new ReturnMessageException(krepe.getCancelMessage().orElseGet(() -> Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kit.cancelledpre", kit.getName())));
                }
                case NO_SPACE: {
                    throw ReturnMessageException.fromKey("command.kit.give.fullinventorynosave", playerName);
                }
            }
            throw ReturnMessageException.fromKey("command.kit.give.fail", playerName, kitName);
        }
    }

    @Override
    public void onReload() {
        KitConfigAdapter kca = (KitConfigAdapter)this.getServiceUnchecked(KitConfigAdapter.class);
        this.isDrop = ((KitConfig)kca.getNodeOrDefault()).isDropKitIfFull();
        this.mustGetAll = ((KitConfig)kca.getNodeOrDefault()).isMustGetAll();
    }
}

