/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.commands.kit;

import io.github.nucleuspowered.nucleus.api.nucleusdata.Kit;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.modules.kit.commands.KitFallbackBase;
import io.github.nucleuspowered.nucleus.modules.kit.commands.kit.KitCommand;
import io.github.nucleuspowered.nucleus.modules.kit.services.KitHandler;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(prefix="kit")
@RegisterCommand(value={"rename"}, subcommandOf=KitCommand.class)
@RunAsync
@NoModifiers
@NonnullByDefault
public class KitRenameCommand
extends KitFallbackBase<CommandSource> {
    private final String name = "target name";

    @Override
    protected CommandElement[] getArguments() {
        return new CommandElement[]{KitFallbackBase.KIT_PARAMETER_NO_PERM_CHECK, GenericArguments.onlyOne((CommandElement)GenericArguments.string((Text)Text.of((String)this.name)))};
    }

    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        try {
            String name1 = ((Kit)args.getOne("kit").get()).getName();
            String name2 = (String)args.getOne(this.name).get();
            ((KitHandler)this.getServiceUnchecked(KitHandler.class)).renameKit(name1, name2);
            this.sendMessageTo(src, "command.kit.rename.renamed", new String[]{name1, name2});
            return CommandResult.success();
        }
        catch (IllegalArgumentException e) {
            throw new ReturnMessageException(Text.of((Object[])new Object[]{TextColors.RED, e.getMessage()}));
        }
    }
}

