/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.commands.kit;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Kit;
import io.github.nucleuspowered.nucleus.internal.annotations.Since;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.kit.commands.KitFallbackBase;
import io.github.nucleuspowered.nucleus.modules.kit.commands.kit.KitCommand;
import io.github.nucleuspowered.nucleus.modules.kit.config.KitConfig;
import io.github.nucleuspowered.nucleus.modules.kit.config.KitConfigAdapter;
import java.util.List;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.property.InventoryTitle;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(prefix="kit", suggestedLevel=SuggestedLevel.ADMIN)
@RegisterCommand(value={"view"}, subcommandOf=KitCommand.class)
@NoModifiers
@NonnullByDefault
@Since(spongeApiVersion="7.0", minecraftVersion="1.12.1", nucleusVersion="1.2")
public class KitViewCommand
extends KitFallbackBase<Player>
implements Reloadable {
    private boolean processTokens = false;

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{KitFallbackBase.KIT_PARAMETER_PERM_CHECK};
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        Kit kitInfo = (Kit)args.getOne("kit").get();
        Inventory inventory = Util.getKitInventoryBuilder().property("inventorytitle", (InventoryProperty)InventoryTitle.of((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kit.view.title", kitInfo.getName()))).build((Object)Nucleus.getNucleus());
        List<ItemStack> lis = kitInfo.getStacks().stream().filter(x -> !x.getType().equals(ItemTypes.NONE)).map(ItemStackSnapshot::createStack).collect(Collectors.toList());
        if (this.processTokens) {
            KIT_HANDLER.processTokensInItemStacks(src, lis);
        }
        lis.forEach(arg_0 -> ((Inventory)inventory).offer(arg_0));
        return src.openInventory(inventory).map(x -> {
            KIT_HANDLER.addViewer((Container)x);
            return CommandResult.success();
        }).orElseThrow(() -> ReturnMessageException.fromKey("command.kit.view.cantopen", kitInfo.getName()));
    }

    @Override
    public void onReload() {
        this.processTokens = ((KitConfig)((KitConfigAdapter)this.getServiceUnchecked(KitConfigAdapter.class)).getNodeOrDefault()).isProcessTokens();
    }
}

