/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.commands.kit.command;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Kit;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.modules.kit.commands.KitFallbackBase;
import io.github.nucleuspowered.nucleus.modules.kit.commands.kit.KitCommand;
import io.github.nucleuspowered.nucleus.modules.kit.commands.kit.command.KitRemoveCommandCommand;
import java.util.ArrayList;
import java.util.List;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NoModifiers
@NonnullByDefault
@RunAsync
@Permissions(prefix="kit")
@RegisterCommand(value={"command", "commands"}, subcommandOf=KitCommand.class)
public class KitCommandCommand
extends KitFallbackBase<CommandSource> {
    private final String removePermission = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(KitRemoveCommandCommand.class).getBase();
    private final Text removeIcon = Text.of((Object[])new Object[]{TextColors.WHITE, "[", TextColors.DARK_RED, "X", TextColors.WHITE, "]"});

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{KitFallbackBase.KIT_PARAMETER_PERM_CHECK};
    }

    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        Kit kit = (Kit)args.getOne("kit").get();
        List<String> commands = kit.getCommands();
        if (commands.isEmpty()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kit.command.nocommands", kit.getName()));
        } else {
            ArrayList cc = Lists.newArrayList();
            for (int i = 0; i < commands.size(); ++i) {
                Text t = Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kit.command.commands.entry", String.valueOf(i + 1), commands.get(i));
                if (this.hasPermission((Subject)src, this.removePermission)) {
                    t = Text.of((Object[])new Object[]{Text.builder().append(new Text[]{this.removeIcon}).onClick((ClickAction)TextActions.runCommand((String)("/nucleus:kit command remove " + kit.getName() + " " + commands.get(i)))).onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kit.command.removehover", new String[0]))).build(), " ", t});
                }
                cc.add(t);
            }
            Util.getPaginationBuilder(src).title(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kit.command.commands.title", kit.getName())).contents((Iterable)cc).sendTo((MessageReceiver)src);
        }
        return CommandResult.success();
    }
}

