/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.message.commands;

import io.github.nucleuspowered.nucleus.argumentparsers.MessageTargetArgument;
import io.github.nucleuspowered.nucleus.argumentparsers.NicknameArgument;
import io.github.nucleuspowered.nucleus.argumentparsers.SelectorArgument;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NotifyIfAFK;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.message.services.MessageHandler;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(suggestedLevel=SuggestedLevel.USER, supportsSelectors=true)
@RegisterCommand(value={"message", "m", "msg", "whisper", "w", "t"}, rootAliasRegister={"tell"})
@EssentialsEquivalent(value={"msg", "tell", "m", "t", "whisper"})
@NonnullByDefault
@NotifyIfAFK(value={"to"})
public class MessageCommand
extends AbstractCommand<CommandSource> {
    static final String TO = "to";
    private final MessageHandler handler = (MessageHandler)this.getServiceUnchecked(MessageHandler.class);

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> mp = new HashMap<String, PermissionInformation>();
        mp.put("color", PermissionInformation.getWithTranslation("permission.message.color", SuggestedLevel.ADMIN));
        mp.put("colour", PermissionInformation.getWithTranslation("permission.message.colour", SuggestedLevel.ADMIN));
        mp.put("style", PermissionInformation.getWithTranslation("permission.message.style", SuggestedLevel.ADMIN));
        mp.put("magic", PermissionInformation.getWithTranslation("permission.message.magic", SuggestedLevel.ADMIN));
        mp.put("url", PermissionInformation.getWithTranslation("permission.message.urls", SuggestedLevel.ADMIN));
        return mp;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.firstParsing((CommandElement[])new CommandElement[]{new MessageTargetArgument((Text)Text.of((String)TO)), new SelectorArgument(new NicknameArgument((Text)Text.of((String)TO), NicknameArgument.Target.PLAYER_CONSOLE), Player.class)}), NucleusParameters.MESSAGE};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        boolean b = this.handler.sendMessage(src, (CommandSource)args.getOne(TO).get(), (String)args.getOne("message").get());
        return b ? CommandResult.success() : CommandResult.empty();
    }
}

