/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.misc.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.data.manipulator.mutable.entity.FoodData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(supportsOthers=true)
@RegisterCommand(value={"feed", "eat"})
@EssentialsEquivalent(value={"feed", "eat"})
@NonnullByDefault
public class FeedCommand
extends AbstractCommand.SimpleTargetOtherPlayer {
    @Override
    protected CommandResult executeWithPlayer(CommandSource src, Player pl, CommandContext args, boolean isSelf) {
        FoodData foodData = pl.getFoodData();
        Value f = foodData.foodLevel().set(foodData.foodLevel().getDefault());
        Value d = foodData.saturation().set(foodData.saturation().getDefault());
        foodData.set(new BaseValue[]{f, d});
        if (pl.offer((ValueContainer)foodData).isSuccessful()) {
            pl.sendMessages(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.feed.success.self", new String[0])});
            if (!pl.equals(src)) {
                src.sendMessages(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.feed.success.other", pl.getName())});
            }
            return CommandResult.success();
        }
        src.sendMessages(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.feed.error", new String[0])});
        return CommandResult.empty();
    }
}

