/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.misc.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.argumentparsers.ItemAliasArgument;
import io.github.nucleuspowered.nucleus.configurate.datatypes.ItemDataNode;
import io.github.nucleuspowered.nucleus.dataservices.ItemDataService;
import io.github.nucleuspowered.nucleus.internal.DataScanner;
import io.github.nucleuspowered.nucleus.internal.EconHelper;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions
@NonnullByDefault
@RegisterCommand(value={"iteminfo", "itemdb"})
@EssentialsEquivalent(value={"itemdb", "itemno", "durability", "dura"}, isExact=false, notes="Nucleus tries to provide much more info!")
public class ItemInfoCommand
extends AbstractCommand<Player> {
    private final ItemDataService itemDataService = Nucleus.getNucleus().getItemDataService();
    private EconHelper econHelper = Nucleus.getNucleus().getEconHelper();
    private final String key = "key";
    private final Text comma = Text.of((Object[])new Object[]{TextColors.GREEN, ", "});

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().permissionFlag(this.permissions.getPermissionWithSuffix("extended"), new String[]{"e", "-extended"}).buildWith(GenericArguments.optional((CommandElement)new ItemAliasArgument((Text)Text.of((String)this.key))))};
    }

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("extended", PermissionInformation.getWithTranslation("permission.iteminfo.extended", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandResult executeCommand(Player player, CommandContext args, Cause cause) throws Exception {
        List<String> aliases;
        ItemStack it;
        Optional catalogTypeOptional = args.getOne(this.key);
        if (catalogTypeOptional.isPresent()) {
            CatalogType ct = (CatalogType)catalogTypeOptional.get();
            if (ct instanceof ItemType) {
                it = ((ItemType)ct).getTemplate().createStack();
            } else {
                BlockState bs = (BlockState)ct;
                it = ((ItemType)bs.getType().getItem().orElseThrow(() -> new CommandException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.iteminfo.invalidblockstate", new String[0])))).getTemplate().createStack();
                it.offer(Keys.ITEM_BLOCKSTATE, (Object)bs);
            }
        } else if (player.getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
            it = (ItemStack)player.getItemInHand(HandTypes.MAIN_HAND).get();
        } else {
            player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.iteminfo.none", new String[0]));
            return CommandResult.empty();
        }
        ArrayList<Text> lt = new ArrayList<Text>();
        String id = it.getType().getId().toLowerCase();
        lt.add(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.iteminfo.id", it.getType().getId(), it.getTranslation().get()));
        Optional obs = it.get(Keys.ITEM_BLOCKSTATE);
        if (obs.isPresent()) {
            lt.add(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.iteminfo.extendedid", ((BlockState)obs.get()).getId()));
            id = ((BlockState)obs.get()).getId().toLowerCase();
        }
        if (args.hasAny("e") || args.hasAny("extended")) {
            DataScanner.getInstance().getKeysForHolder((DataHolder)it).entrySet().stream().filter(x -> x.getValue() != null).filter(x -> {
                try {
                    return it.supports((Key)x.getValue());
                }
                catch (Exception e) {
                    return false;
                }
            }).forEach(x -> {
                Key k = (Key)x.getValue();
                if (it.get(k).isPresent()) {
                    DataScanner.getText((CommandSource)player, "command.iteminfo.key", (String)x.getKey(), it.get(k).get()).ifPresent(lt::add);
                }
            });
        }
        ItemDataNode itemDataNode = this.itemDataService.getDataForItem(id);
        if (this.econHelper.economyServiceExists() && Nucleus.getNucleus().getModuleContainer().isModuleLoaded("server-shop")) {
            double sellPrice;
            boolean space = false;
            double buyPrice = itemDataNode.getServerBuyPrice();
            if (buyPrice >= 0.0) {
                lt.add(Text.EMPTY);
                lt.add(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.iteminfo.buyprice", this.econHelper.getCurrencySymbol(buyPrice)));
                space = true;
            }
            if ((sellPrice = itemDataNode.getServerSellPrice()) >= 0.0) {
                if (!space) {
                    lt.add(Text.EMPTY);
                }
                lt.add(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.iteminfo.sellprice", this.econHelper.getCurrencySymbol(sellPrice)));
            }
        }
        if (!(aliases = itemDataNode.getAliases()).isEmpty()) {
            lt.add(Text.EMPTY);
            lt.add(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.iteminfo.list.aliases", new String[0]));
            Text.Builder tb = Text.builder();
            Iterator<String> iterator = aliases.iterator();
            tb.append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, iterator.next()})});
            while (iterator.hasNext()) {
                tb.append(new Text[]{this.comma, Text.of((Object[])new Object[]{TextColors.YELLOW, iterator.next()})});
            }
            lt.add(tb.build());
        }
        ((PaginationService)Sponge.getServiceManager().provideUnchecked(PaginationService.class)).builder().contents(lt).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).title(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.iteminfo.list.header", new String[0])).sendTo((MessageReceiver)player);
        return CommandResult.success();
    }
}

