/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mute.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions
@RunAsync
@NoModifiers
@NonnullByDefault
@RegisterCommand(value={"checkmuted"})
public class CheckMutedCommand
extends AbstractCommand<CommandSource> {
    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        MessageProvider provider = Nucleus.getNucleus().getMessageProvider();
        List<UUID> usersInMute = Nucleus.getNucleus().getUserCacheService().getMuted();
        if (usersInMute.isEmpty()) {
            src.sendMessage(provider.getTextMessageWithFormat("command.checkmuted.none", new String[0]));
            return CommandResult.success();
        }
        Util.getPaginationBuilder(src).title(provider.getTextMessageWithFormat("command.checkmuted.header", new String[0])).contents((Iterable)usersInMute.stream().map(x -> {
            Text name = Nucleus.getNucleus().getNameUtil().getName((UUID)x).orElseGet(() -> Text.of((Object[])new Object[]{"unknown: ", x.toString()}));
            return name.toBuilder().onHover((HoverAction)TextActions.showText((Text)provider.getTextMessageWithFormat("command.checkmuted.hover", new String[0]))).onClick((ClickAction)TextActions.runCommand((String)("/nucleus:checkmute " + x.toString()))).build();
        }).collect(Collectors.toList())).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }
}

