/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mute.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.mute.config.MuteConfig;
import io.github.nucleuspowered.nucleus.modules.mute.config.MuteConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.mute.data.MuteData;
import io.github.nucleuspowered.nucleus.modules.mute.services.MuteHandler;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import io.github.nucleuspowered.nucleus.util.PermissionMessageChannel;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Permissions(suggestedLevel=SuggestedLevel.MOD)
@RunAsync
@NoModifiers
@RegisterCommand(value={"mute", "unmute"})
@EssentialsEquivalent(value={"mute", "silence"})
public class MuteCommand
extends AbstractCommand<CommandSource>
implements Reloadable {
    private final MuteHandler handler = (MuteHandler)this.getServiceUnchecked(MuteHandler.class);
    private boolean requireUnmutePermission = false;
    private long maxMute = Long.MAX_VALUE;
    private static final String mutedChatPermission = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(MuteCommand.class).getPermissionWithSuffix("seemutedchat");

    public static String getMutedChatPermission() {
        return mutedChatPermission;
    }

    @Override
    public Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("unmute", PermissionInformation.getWithTranslation("permission.mute.unmute", SuggestedLevel.MOD));
        m.put("exempt.length", PermissionInformation.getWithTranslation("permission.mute.exempt.length", SuggestedLevel.ADMIN));
        m.put("exempt.target", PermissionInformation.getWithTranslation("permission.mute.exempt.target", SuggestedLevel.MOD));
        m.put("notify", PermissionInformation.getWithTranslation("permission.mute.notify", SuggestedLevel.MOD));
        m.put("seemutedchat", PermissionInformation.getWithTranslation("permission.mute.seemutedchat", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.ONE_USER, NucleusParameters.OPTIONAL_WEAK_DURATION, NucleusParameters.OPTIONAL_REASON};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        User user = (User)args.getOne("user").get();
        Optional time = args.getOne("duration");
        Optional<MuteData> omd = this.handler.getPlayerMuteData(user);
        Optional reas = args.getOne("reason");
        if (this.permissions.testSuffix((Subject)user, "exempt.target", src, false)) {
            throw ReturnMessageException.fromKey("command.mute.exempt", user.getName());
        }
        if (omd.isPresent() && !time.isPresent() && !reas.isPresent()) {
            if (!this.requireUnmutePermission || this.permissions.testSuffix((Subject)src, "unmute")) {
                this.handler.unmutePlayer(user, CauseStackHelper.createCause(src), false);
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.unmute.success", user.getName(), src.getName()));
                return CommandResult.success();
            }
            throw ReturnMessageException.fromKey("command.unmute.perm", new Object[0]);
        }
        String rs = reas.orElse(Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("command.mute.defaultreason", new String[0]));
        UUID ua = Util.consoleFakeUUID;
        if (src instanceof Player) {
            ua = ((Player)src).getUniqueId();
        }
        if (this.maxMute > 0L && time.orElse(Long.MAX_VALUE) > this.maxMute && !this.permissions.testSuffix((Subject)src, "exempt.length")) {
            throw ReturnMessageException.fromKey("command.mute.length.toolong", Util.getTimeStringFromSeconds(this.maxMute));
        }
        MuteData data = time.isPresent() ? (!user.isOnline() ? new MuteData(ua, rs, Duration.ofSeconds((Long)time.get())) : new MuteData(ua, rs, Instant.now().plus((long)((Long)time.get()), ChronoUnit.SECONDS))) : new MuteData(ua, rs);
        if (this.handler.mutePlayer(user, data)) {
            MutableMessageChannel mc = new PermissionMessageChannel(this.permissions.getPermissionWithSuffix("notify")).asMutable();
            mc.addMember((MessageReceiver)src);
            if (time.isPresent()) {
                this.timedMute(src, user, data, (Long)time.get(), (MessageChannel)mc);
            } else {
                this.permMute(src, user, data, (MessageChannel)mc);
            }
            return CommandResult.success();
        }
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.mute.fail", user.getName()));
        return CommandResult.empty();
    }

    private void timedMute(CommandSource src, User user, MuteData data, long time, MessageChannel mc) {
        String ts = Util.getTimeStringFromSeconds(time);
        mc.send(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.mute.success.time", user.getName(), src.getName(), ts));
        mc.send(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("standard.reasoncoloured", data.getReason()));
        if (user.isOnline()) {
            ((Player)user.getPlayer().get()).sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("mute.playernotify.time", ts));
            ((Player)user.getPlayer().get()).sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.reason", data.getReason()));
        }
    }

    private void permMute(CommandSource src, User user, MuteData data, MessageChannel mc) {
        mc.send(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.mute.success.norm", user.getName(), src.getName()));
        mc.send(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("standard.reasoncoloured", data.getReason()));
        if (user.isOnline()) {
            ((Player)user.getPlayer().get()).sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("mute.playernotify.standard", new String[0]));
            ((Player)user.getPlayer().get()).sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.reason", data.getReason()));
        }
    }

    @Override
    public void onReload() {
        MuteConfigAdapter mca = (MuteConfigAdapter)this.getServiceUnchecked(MuteConfigAdapter.class);
        this.requireUnmutePermission = ((MuteConfig)mca.getNodeOrDefault()).isRequireUnmutePermission();
        this.maxMute = ((MuteConfig)mca.getNodeOrDefault()).getMaximumMuteLength();
    }
}

