/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mute.data;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.nucleusdata.MuteInfo;
import io.github.nucleuspowered.nucleus.internal.data.EndTimestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;

@ConfigSerializable
public final class MuteData
extends EndTimestamp
implements MuteInfo {
    @Setting
    private UUID muter;
    @Setting
    private String reason;
    @Setting
    private long creationTime = Instant.now().getEpochSecond();

    public MuteData() {
    }

    public MuteData(UUID muter, String reason) {
        this.muter = muter;
        this.reason = reason;
    }

    public MuteData(UUID muter, String reason, Instant endtimestamp) {
        this(muter, reason);
        this.endtimestamp = endtimestamp.getEpochSecond();
    }

    public MuteData(UUID muter, String reason, @Nullable Duration timeFromNextLogin) {
        this(muter, reason);
        if (timeFromNextLogin != null) {
            this.timeFromNextLogin = timeFromNextLogin.getSeconds();
        }
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public Optional<Instant> getEndTimestamp() {
        if (this.endtimestamp == null) {
            return Optional.empty();
        }
        return Optional.of(Instant.ofEpochSecond(this.endtimestamp));
    }

    @Override
    public Optional<Instant> getCreationInstant() {
        return this.creationTime > 0L ? Optional.of(Instant.ofEpochSecond(this.creationTime)) : Optional.empty();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public Optional<UUID> getMuter() {
        return this.muter.equals(Util.consoleFakeUUID) ? Optional.empty() : Optional.of(this.muter);
    }

    public UUID getMuterInternal() {
        return this.muter;
    }

    @Override
    public Optional<Duration> getTimeFromNextLogin() {
        if (this.timeFromNextLogin == null) {
            return Optional.empty();
        }
        return Optional.of(Duration.of(this.timeFromNextLogin, ChronoUnit.SECONDS));
    }
}

