/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.nameban.services;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.exceptions.NucleusException;
import io.github.nucleuspowered.nucleus.api.service.NucleusNameBanService;
import io.github.nucleuspowered.nucleus.internal.annotations.APIService;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import io.github.nucleuspowered.nucleus.modules.nameban.events.NameBanEvent;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;

@APIService(value=NucleusNameBanService.class)
public class NameBanHandler
implements NucleusNameBanService,
ServiceBase {
    private final Nucleus plugin = Nucleus.getNucleus();

    @Override
    public boolean addName(String name, String reason, Cause cause) throws NucleusException {
        if (Util.usernameRegex.matcher(name).matches()) {
            if (Nucleus.getNucleus().getNameBanService().setBan(name, reason)) {
                Sponge.getEventManager().post((Event)new NameBanEvent.Banned(name, reason, cause));
                Sponge.getServer().getOnlinePlayers().stream().filter(x -> x.getName().equalsIgnoreCase(name)).findFirst().ifPresent(x -> x.kick(TextSerializers.FORMATTING_CODE.deserialize(reason)));
                return true;
            }
            return false;
        }
        throw new NucleusException((Text)Text.of((String)"That is not a valid username."), NucleusException.ExceptionType.DISALLOWED_NAME);
    }

    @Override
    public Optional<String> getReasonForBan(String name) {
        return Nucleus.getNucleus().getNameBanService().getBanReason(name.toLowerCase());
    }

    @Override
    public boolean removeName(String name, Cause cause) throws NucleusException {
        if (Util.usernameRegex.matcher(name).matches()) {
            Optional<String> reason = this.getReasonForBan(name);
            if (reason.isPresent() && Nucleus.getNucleus().getNameBanService().removeBan(name)) {
                Sponge.getEventManager().post((Event)new NameBanEvent.Unbanned(name, reason.get(), cause));
                return true;
            }
            return false;
        }
        throw new NucleusException((Text)Text.of((String)"That is not a valid username."), NucleusException.ExceptionType.DISALLOWED_NAME);
    }
}

